/*
 *
 * $Id: proc_req.h,v 1.2.4.41 2000/03/16 17:13:05 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  process
 * incoming requests.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __PROC_REQ_H
#define __PROC_REQ_H


#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

/* Standard error codes for pvmsync */
#ifndef __PVMERRS_H
#include <include/pvmerrs.h>
#endif


/* Booleans!! */
#ifndef TRUE
  #define TRUE              0x1
#endif

#ifndef FALSE
  #define FALSE             0x0
#endif


/* Process requests to create/destroy/operate on sync mechanisms
   and shared data objects */
void *proc_req __P ((void *index));

int mutex_create __P ((char *mutex_name, int length));

int mutex_dest __P ((char *mutex_name, int length));

int mutex_lock __P ((char *mutex_name, int length, unsigned int addr));

int mutex_trylock __P ((char *mutex_name, int length, unsigned int addr));

int mutex_unlock __P ((char *mutex_name, int length, unsigned int addr,
							int sentry_val));

int sem_create __P ((char *sem_name, int length, unsigned int sem_val));

int sem_dest __P ((char *sem_name, int length));

int sem_p __P ((char *sem_name, int length, int try));

int sem_v __P ((char *sem_name, int length));

int integer_create __P ((char *int_name, int length));

int float_create __P ((char *float_name, int length));

int mem_create __P ((char *block_name, int length, int size));

int integer_dest __P ((char *int_name, int length));

int float_dest __P ((char *float_name, int length));

int mem_dest __P ((char *block_name, int length));

int integer_set __P ((char *int_name, int length, pvm_int64_t value));

int float_set __P ((char *float_name, int length, pvm_float64_t value));

int mem_set __P ((char *block_name, int length, void *ptr, int size));

pvm_int64_t integer_get __P ((char *int_name, int length));

pvm_float64_t float_get __P ((char *float_name, int length));

void * mem_get __P ((char *block_name, int length, int *size));

int cond_create __P ((char *cv_name, int length));

int cond_dest __P ((char *cv_name, int length));

int cv_sig __P ((char *cv_name, int length, int broadc_flag));

#define cond_broadcast(cv_name, length) cv_sig (cv_name, length, 1)

#define cond_signal(cv_name, length) cv_sig (cv_name, length, 0)

int cond_timedwait __P ((char *cv_name, int cv_len, time_t secs));

#define cond_wait(cv_name, cv_len) \
        cond_timedwait (cv_name, cv_len, 0)


#endif /* __PROC_REQ_H */


