/*
 *
 * $Id: logging.c,v 1.2.4.41 2000/03/16 17:12:51 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  logging
 * routines.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __LOGGING_H
#include <logging.h>
#endif

#include <pthread.h>

#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

/* Standard error codes for pvmsync */
#ifndef __PVMERRS_H
#include <headers/pvmerrs.h>
#endif

/* fd for our log file */
extern int log_fd;

inline void report_log(char *mesg)
{
time_t time_p;
struct tm *now_time;
  /* for asctime_r */
char timebuf[26], log_str[128];
char *curr_timestr;

  #ifdef __LOG_SYSLOG
    #ifndef DEBUG
      openlog ("pvmsync", LOG_CONS | LOG_PID, LOG_USER);
    #endif

      syslog (LOG_INFO, mesg);

    #ifndef DEBUG
      closelog();
    #endif
  #else
      (void) time (&time_p);
      now_time = localtime (&time_p);
      curr_timestr = asctime_r (now_time, timebuf);
      curr_timestr[strlen(curr_timestr)-1] = '\0';
      snprintf(log_str, 128, "%s pvmsync[%d]: %s",
				curr_timestr, getpid(), mesg);
      (void) write (log_fd, log_str, strlen(log_str));
  #endif

}



