/*
 *
 * $Id: lib_internals.h,v 1.2.4.41 2000/03/16 17:13:58 ajp Exp $
 *
 * Andrew Pitman              lib_internals.h
 *
 * pvmsync, a distributed synchronization server:  declarations
 * of internal functions for the pvmsync client library.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __LIB_INTERNALS_H
#define __LIB_INTERNALS_H


/* struct timeval in bits/time.h */
#include <time.h>
#define __need_timeval
#include <bits/time.h>

/* Object types according to udp server */
#include <include/pvm_gen.h>

/* pvm_mutex */
#include <pvm_mutex.h>

/* pvm_cond */
#include <pvm_cv.h>

/* pvm_sem */
#include <pvm_sem.h>

/* pvm_sd */
#include <pvm_sd.h>

/* Max number of fd ever used */
#define __MAX_FDS          256

/* Max amount of time to wait total
   (secs) for a response from a server */
#define __MAX_CUM_TIMEOUT  1800

/* struct udp_app_dgram */
#ifndef __UDP_DAEMON_H
  #include <udp_daemon.h>
#endif

/* struct sockaddr_in */
#include <sys/types.h>
#include <sys/socket.h>

/* (Singly, unsorted) linked list of candidate nodes'
   addresses and load will consist of elements of this type */
struct __pvm_host_cand {
  struct udp_app_dgram dgram;
  struct sockaddr_in s_addr;
  size_t s_addr_len;
  struct __pvm_host_cand *next;
};

/* Find out if obj_symbol, of type obj_type exists on the cluster */
extern int __pvm_symbol_exists __P ((pvm_t __obj_type, char *__obj_symbol));

/* Find a suitable server to hold __obj_type and fill in __s_addr
   and __s_addr_len */
/* Returns -1 on error, zero otherwise */
extern int __pvm_find_available __P ((pvm_t __obj_type,
                                      struct sockaddr_in *__s_addr,
                                      size_t *__s_addr_len));

#ifndef __LOOPBACK_ADDR
  #define __LOOPBACK_ADDR         "127.0.0.1"
#endif

/* Create a symbol on the local server, if possible.  Return -1 if
   object cannot be created on the localhost. */
extern int __pvm_create_local __P ((pvm_t __obj_type, char *__obj_name, ...));

/* Lock/Trylock mutex */
/* Blocking lock if __try is 0, nonblocking if __try is 1 */
extern int __pvm_mutex_lock __P ((pvm_mutex *__mutex, int __try));

/* Wait/Trywait semaphore */
/* Blocking wait if __try is 0, nonblocking if __try is 1 */
extern int __pvm_sem_wait __P ((pvm_sem *__sem, int __try));

/* Init shared objects of type int, float, and mem, respectively */
/* Initialize an integer object */
extern int __pvm_int_init __P ((pvm_sd *__sd));

/* Initialize a float object */
extern int __pvm_float_init __P ((pvm_sd *__sd));

/* This one takes the size of the block to create */
/* Initialize a memory block object */
extern int __pvm_mem_init __P ((pvm_sd *__sd, size_t __size));

/* Get the value of the appropriate shared object and fill in
   sd->sym_value to length __sd->sym_size */
/* Get the value of an integer or float object */
extern int __pvm_scalar_get __P ((pvm_sd *__sd));

/* Get the value of a mem object */
extern int __pvm_mem_get __P ((pvm_sd *__sd));

/* Set the value of the appropriate shared object */
/* Set the value of an integer or float object */
extern int __pvm_scalar_set __P ((pvm_sd *__sd));

/* Set the value of a mem object */
extern int __pvm_mem_set __P ((pvm_sd *__sd));

/* Wait on condition variable cv until timer (unsigned int __secs)
   goes off, or indefinitely if __secs == 0 */
extern int __pvm_cond_timedwait __P ((pvm_cond *__cv, unsigned int __secs));

/* Signal condition variable */
/* Broadcast if int __broadcast is nonzero. */
extern int __pvm_cond_signal __P ((pvm_cond *__cv, int __broadcast));

/* Add contents of struct timeval __itv to sum *__stv.... */
/* Keep a running tally of time given in struct timeval's */
inline void __pvm_update_tv_sum __P ((struct timeval __itv,
                                      struct timeval *__stv));

/* Add element to LL __list */
void __pvm_add_to_list __P ((struct __pvm_host_cand *__element,
                             void *__list));

/* Destroy the whole thing */
void __pvm_destroy_list __P ((void *__list));

/* Return a pointer to the entry for the best candidate,
   given list.... NULL on failure.  Values must be extracted
   from element before __pvm_destroy_list is called */
extern struct __pvm_host_cand *  __pvm_find_best __P ((void *__list));

/* Calculate square */
extern inline int __pvm_sqr __P ((int __val));

/* Calculate the next timeout value.  Increases exponenitally.
   Starts at 2 msec, then increases to 2 seconds. */
/* timeval passed initially should = { 0, 0 } */
inline void __pvm_calc_timeout __P ((struct timeval *__tv));

/* Sanitize part (or all) of a variable name */
inline void __pvm_sanitize_sym __P ((char *__varname));

/* Generate first character of symbol name, since objects
   are placed in hash tables indexed by 1st char.  We want
   to mix things up a bit.... */
extern inline char __pvm_gen_initchar ();

/* Generic init function for synchronization primitives */
/* Return 0 on success, -1 on failure (set errno) */
extern int __pvm_generic_init_sync __P ((pvm_t __obj_type,
                                         void *__obj_ptr, ...));

/* Generic destroy function for synchronization primitives */
/* Return 0 on success, -1 on failure (set errno) */
extern int __pvm_generic_destroy_sync __P ((pvm_t __obj_type,
                                            void *__obj_ptr));

/* Send contents of buffer to tcp server given by address __send_addr
   (which is presumably in the correct format) and parse the return
   value out from the reply.  This routine handles setting up the
   connection. */
/* Return 0 on success, -1 on failure (set errno) */
extern int __pvm_tcp_server_sendreq __P ((char *__buff, size_t __bufflen,
                                      struct sockaddr_in __send_addr));


#endif /* __LIB_INTERNALS_H */


