/*
 *
 * $Id: initialize.h,v 1.2.4.41 2000/03/16 17:12:44 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  initialization
 * routines.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __INITIALIZE_H
#define __INITIALIZE_H


#ifndef __CONFIG_H
#include <config.h>
#endif


#include <time.h>


/* Init rundir... 0 on success, -1 on failure */
int init_rundir ();

/* Open syslog or runfile */
/* 0 on success, -1 on failure */
int init_log ();

/* Write to PID file */
/* 0 on success,  -1 on failure */
int wr_pid();

/* Call funcs to init pools of different resources, init
   random number generator, open UNIX socket */
/* 0 on success, -1 on failure */
int gen_init ();

/* Initialize hash table of mutexes */
/* Returns 0 on success and -1 on error */
int init_mutex_pool __P ((int num_ents));

/* Initialize our pool of semaphores'
   corresponding info/ sync mechanisms. */
int init_sem_pool __P ((int num_sems));

/* Initialize hash table of condition variables */
/* Returns 0 on success and -1 on error */
int init_cond_pool __P ((int num_ents));


#endif /* __INITIALIZE_H */


