/*
 *
 * $Id: pvmsync.h,v 1.2.4.41 2000/03/16 17:13:46 ajp Exp $
 *
 * Andrew Pitman              pvmsync.h
 *
 * pvmsync, a distributed synchronization server:  Main header
 * file for pvmsync client library, includes object-specific
 * and general purpose headers.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999 Andrew J. Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __PVMSYNC_H
#define __PVMSYNC_H


 /* Main header file for pvmsync client library, includes
    object-specific and general purpose headers. */


/* General-purpose pvmsync client routines */
#include <pvm_gen.h>
/* Standard error codes for pvmsync */
#include <pvmerrs.h>

/* Mutex-specific client routines */
#include <pvm_mutex.h>
/* Condition variable specific client routines */
#include <pvm_cv.h>
/* Semaphore-specific client routines */
#include <pvm_sem.h>
/* Shared data specific client routines */
#include <pvm_sd.h>


#endif /* __PVMSYNC_H */

