/*
 *
 * $Id: pvmerrs.h,v 1.2.4.41 2000/03/16 17:13:43 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  Standard
 * error codes for pvmsync.
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __PVMERRS_H
#define __PVMERRS_H


__BEGIN_DECLS

#if (!defined (_ERRNO_H) && !defined (_LINUX_ERRNO_H))

#define EPERM            1      /* Operation not permitted */
#define ESRCH            3      /* No such process */
#define EINTR            4      /* Interrupted system call */
#define EIO              5      /* I/O error */
#define E2BIG            7      /* Arg list too long */
#define EAGAIN          11      /* Try again */
#define ENOMEM          12      /* Out of memory */
#define EACCES          13      /* Permission denied */
#define EBUSY           16      /* Device or resource busy */
#define EINVAL          22      /* Invalid argument */
#define ENOSPC          28      /* No space left on device */
#define EDEADLK         35      /* Resource deadlock would occur */
#define ENOSYS          38      /* Function not implemented */
#define EWOULDBLOCK     EAGAIN  /* Operation would block */
#define EBADE           52      /* Invalid exchange */
#define EDEADLOCK       EDEADLK
#define ENETDOWN        100     /* Network is down */
#define ENETUNREACH     101     /* Network is unreachable */
#define ENETRESET       102     /* Network dropped connection because of reset */
#define ECONNABORTED    103     /* Software caused connection abort */
#define ECONNRESET      104     /* Connection reset by peer */
#define ENOBUFS         105     /* No buffer space available */
#define EISCONN         106     /* Transport endpoint is already connected */
#define ENOTCONN        107     /* Transport endpoint is not connected */
#define ESHUTDOWN       108     /* Cannot send after transport endpoint
                                                              shutdown */
#define ETIMEDOUT       110     /* Connection timed out */
#define ECONNREFUSED    111     /* Connection refused */

#endif /* (!defined (_ERRNO_H) && !defined (_LINUX_ERRNO_H)) */

__END_DECLS


#endif /* __PVMERRS_H   */


