/*
 *
 * $Id: pvm_sem.h,v 1.2.4.41 2000/03/16 17:13:40 ajp Exp $
 *
 * Andrew Pitman              pvm_sem.h
 *
 * pvmsync, a distributed synchronization server:  declarations
 * for semaphore-specific client routines for pvmsync.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __PVM_SEM_H
#define __PVM_SEM_H


#include <pvm_gen.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <errno.h>


/* A pointer to this type must be passed to the
   pvm_sem_wait, pvm_sem_trywait, pvm_sem_post,
   and pvm_sem_destroy.  The struct sockaddr_in
   member must be filled in first by one of:
   pvm_sem_init or pvm_getaddr. */

typedef struct pvm_sem_t {
	char sym_name[PVM_MAX_SYMLEN]; /* Name of semaphore symbol */
	struct sockaddr_in sym_addr; /* Address of server it resides on */
        int sym_index;               /* Index of symbol in pool */
} pvm_sem;


__BEGIN_DECLS

/* These routines follow the convention of returning -1
   and setting errno appropriately. */

/* Initialize a pvm_sem */
/* This pvm_sem will be instantiated on a server, and
   __sem->sym_addr will be filled in with the appropriate
   server address. */
/* Return 0 on success and -1 failure. */
extern int pvm_sem_init __P ((pvm_sem *__sem, unsigned int __value));

/* The given pvm_sem will be destroyed on the server it
   resides on (if possible), or an error returned. */
/* Return 0 on success and -1 on failure. */
extern int pvm_sem_destroy __P ((pvm_sem *__sem));

/* Wait on the semaphore.  __sem must be initialized first,
   or if already created by another process, looked up with
   pvm_getaddr. */
/* Return 0 on success and -1 on failure. */
extern int pvm_sem_wait __P ((pvm_sem *__sem));

/* Wait on the semaphore.  __sem must be initialized first,
   or if already created by another process, looked up with
   pvm_getaddr.  This is the nonblocking version.... it
   will return with an error if waiting on the semaphore
   would block. */
/* Return 0 on success and -1 on failure. */
extern int pvm_sem_trywait __P ((pvm_sem *__sem));

/* Post the semaphore.  Will return with an error if __sem is
   invalid. */
/* Return 0 on success and -1 on failure. */
extern int pvm_sem_post __P ((pvm_sem *__sem));

__END_DECLS


#endif /* __PVM_SEM_H */

