/*
 *
 * $Id: pvm_mutex.h,v 1.2.4.41 2000/03/16 17:13:34 ajp Exp $
 *
 * Andrew Pitman              pvm_mutex.h
 *
 * pvmsync, a distributed synchronization server:  declarations
 * for mutex-specific client routines for pvmsync.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __PVM_MUTEX_H
#define __PVM_MUTEX_H


#include <pvm_gen.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <errno.h>


/* A pointer to this type must be passed to the
   pvm_mutex_lock, pvm_mutex_trylock, pvm_mutex_destroy,
   and pvm_mutex_unlock.  The struct sockaddr_in
   member must be filled in first by one of:
   pvm_mutex_init or pvm_getaddr. */

typedef struct pvm_mutex_t {
	char sym_name[PVM_MAX_SYMLEN]; /* Name of mutex symbol */
	struct sockaddr_in sym_addr; /* Address of server it resides on */
	int sym_lock;                /* Value to return when unlocking */
} pvm_mutex;


__BEGIN_DECLS

/* These routines follow after pthreads convention of
   returning the error number instead of returning -1
   and setting errno. */

/* Initialize a pvm_mutex */
/* This pvm_mutex will be instantiated on a server, and
   __mutex->sym_addr will be filled in with the appropriate
   server address. */
/* Return 0 on success and a positive error code on failure. */
extern int pvm_mutex_init __P ((pvm_mutex *__mutex));

/* The given pvm_mutex will be destroyed on the server it
   resides on (if possible), or an error returned. */
/* Return 0 on success and a positive error code on failure. */
extern int pvm_mutex_destroy __P ((pvm_mutex *__mutex));

/* Lock the mutex.  Mutex must be initialized first, or if
   already created by another process, looked up with
   pvm_getaddr. */
/* Return 0 on success and a positive error code on failure. */
extern int pvm_mutex_lock __P ((pvm_mutex *__mutex));

/* Lock the mutex.  Mutex must be initialized first, or if
   already created by another process, looked up with
   pvm_getaddr.  This is the nonblocking version.... it
   will return with an error if the mutex is already locked
   by another process. */
/* Return 0 on success and a positive error code on failure. */
extern int pvm_mutex_trylock __P ((pvm_mutex *__mutex));

/* Unlock the mutex.  Will return an error if __mutex is
   invalid or if it is still locaked. */
/* Return 0 on success and a positive error code on failure. */
extern int pvm_mutex_unlock __P ((pvm_mutex *__mutex));

__END_DECLS


#endif /* __PVM_MUTEX_H */

