/*
 *
 * $Id: garbage.h,v 1.2.4.41 2000/03/16 17:12:39 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:
 * Garbage Collection
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifdef __DO_GARBAGE_COLLECTION


#ifndef __GARBAGE_H
#define __GARBAGE_H


#include <sys/ioctl.h>

/* Object type definitions, pvm_t type */
#include <include/pvm_gen.h>


/* raise () */
#include <signal.h>


/* Garbage collection routine.  Wakes up
   every *secs seconds. */
/* This runs in a new thread and is started
   by main () */
void *garbage_collect __P ((void *secs));


#endif /* __GARBAGE_H */


#endif /* __DO_GARBAGE_COLLECTION */


