/*
 *
 * $Id: fltpt.c,v 1.2.4.41 2000/03/16 17:12:29 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  initialization
 * routines.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

/* For RW Locks */
#ifndef __USE_UNIX98
  #define __USE_UNIX98
#endif
#include <pthread.h>
#include <semaphore.h>

#ifndef __FLTPT_H
#include <fltpt.h>
#endif

#ifndef __TCP_DAEMON_H
   /* float_pool_t */
#include <tcp_daemon.h>
#endif

/* Protect access to the float pool with a rwlock */
extern pthread_rwlock_t float_init_lock;
extern pthread_rwlockattr_t *float_init_lock_attr;

/* Internal "pool" of pvm_float64_t's. */
extern float_pool_t float_pool[CONCURRENT_INSTANCES];

/* Keep a counter of the number of objects we have of this type */
extern unsigned int num_floating;

/* What we were called as */
extern char *progname;

int init_float_array (int num_floats)
{
int status, j;

  num_floating = 0;

  if (num_floats != CONCURRENT_INSTANCES) {
        fprintf(stderr, "%s: init_float_array: invalid index\n", progname);
        return -1;
  }

        /* Init read/write lock for initialization and search */
        float_init_lock_attr = (pthread_rwlockattr_t *) malloc
                                  (sizeof (pthread_rwlockattr_t));

        status = pthread_rwlockattr_init (float_init_lock_attr);
        if (status) {
            fprintf(stderr,
                "%s: init_float_array: error initializing rw lock attribs\n",
                        progname);
            return -1;
        }

        status = pthread_rwlockattr_setkind_np (float_init_lock_attr,
                                        PTHREAD_RWLOCK_PREFER_READER_NP);
        if (status) {
            fprintf(stderr,
                "%s: init_float_array: error setting rw lock attribs\n",
                        progname);
            return -1;
        }

        status = pthread_rwlock_init (&float_init_lock, float_init_lock_attr);
        if (status) {
            fprintf(stderr,
                "%s: init_float_array: error initializing read-write lock\n",
                        progname);
            return -1;
        }

        free (float_init_lock_attr);

  for (j = 0; j < num_floats; j++) {
	status = pthread_mutex_init (&float_pool[j].mutex, NULL);
	if (status) {
            fprintf(stderr,
                "%s: init_float_array: error initializing mutex #%d\n",
                        progname, j+1);
            return -1;
        }
	/* Set float_pool[j].valid to INVALID */
	float_pool[j].valid = (short int) INVALID;
	/* Set value of float to 0 */
	float_pool[j].data = (pvm_float64_t) 0;
	/* Null-out the symbol name */
	(void) memset (float_pool[j].symbol, 0, SYMBOL_LENGTH);
        float_pool[j].access_time = 0;
  }

return 0;
}


