/*
 *
 * $Id: accept_local.h,v 1.2.4.41 2000/03/16 17:12:23 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  Process
 * requests from the UDP server.  These requests discover
 * whether or not the localhost has a given symbol, and how
 * busy the localhost is in processing requests.
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __ACCEPT_LOCAL_H
#define __ACCEPT_LOCAL_H


#include <sys/ioctl.h>

/* Object type definitions, pvm_t type */
#include <include/pvm_gen.h>


/* Accept connections from the UDP daemon */
/* over a UNIX domain socket */
void *accept_local __P ((void *disc_fd));

/* Handle requests for resource information */
void *resource_query __P ((void *curr_index));

/* Does this server have mutex_name? */
int have_mutex __P ((char *mutex_name));

/* Does this server have sem_name? */
int have_sem __P ((char *sem_name));

/* Does this server have int_name? */
int have_int __P ((char *int_name));

/* Does this server have float_name? */
int have_float __P ((char *float_name));

/* Does this server have memptr_name? */
int have_memptr __P ((char *memptr_name));

/* How many objects of type type does this server have left? */
int get_numobjs __P ((pvm_t type));

/* Does this server have cv_name? */
int have_cv __P ((char *cv_name));


#endif /* __ACCEPT_LOCAL_H */


