/******************************************************************************
 *
 * pcc.c Psuedo compiler front end to "p2c" translator.
 * Copyright (C) 1997-1998 Robert Canup.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Revision 1.1 Mar 26,1997   Include options to be passed to p2c by + syntax
 * Revision 1.2 Apr 13,1997   Include erasure of .log files
 * Revision 1.3 Jan 3,1998    Clear up use of -o inside of command line
 *****************************************************************************/

#define _POSIX_SOURCE 1
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PATH 256

#define TRUE -1;
#define FALSE 0;

/******************************************************************************
 *
 * Modify these lines if the .h files have been moved, or if libp2c is in 
 * a different location.
 *
 *****************************************************************************/

char INCLD[] = "-I/usr/include " ;
char LIBR[] = "/usr/lib/libp2c.a " ;

/******************************************************************************
 *
 * Modify this string to change the version message printed by program when it
 * is run with no input parameters.
 *
 *****************************************************************************/

char blurb[] = "pcc version 1.3.0 GNU copyleft 1998 Robert Canup" ;

/******************************************************************************
 *
 * Modify these strings to use a compiler other than gcc, or a translator 
 * other than p2c
 *
 *****************************************************************************/
 
char cc[] = "gcc ";
char xlat[] = "p2c ";
char typeIden = 'p';  /* Pascal files end with a '.p' */
 
/******************************************************************************
 *
 * Function prototypes
 *
 *****************************************************************************/

  
void clearStr(char *name);
int main(int argc, char *argv[]);

/******************************************************************************
 *
 * This routine will set a string to all 0x0 values to solve problems with
 * strncat();
 *
 *****************************************************************************/

 

void clearStr(char *name)
{
int x;
	for(x=0; x < MAX_PATH+1; x++)
	{
		name[x] = 0x0;
	}
}

/******************************************************************************
 *
 * Main routine passes parameters to translator and calls c compiler with
 * options given to it.
 *
 *****************************************************************************/

 
int main(int argc, char *argv[])
{
char	thisArg[MAX_PATH+1];
char	ccstring[MAX_PATH+1];
char	filename[MAX_PATH+1];
char	cfile[MAX_PATH+1];
char	ostring[MAX_PATH+1];
char	optstring[MAX_PATH+1];
char	rmstring[MAX_PATH+1];

/*** Rev 1.2 mod ***/
char	rmlstring[MAX_PATH+1];
/*** End of Rev 1.2 mod ***/

char	temp[MAX_PATH+1];
char	rmhstring[MAX_PATH+1];

/*** Rev 1.1 mod ***/
char	p2copts[MAX_PATH+1];
/*** End of Rev 1.1 mod ***/

int oflag ;
int compileOnly ;
int x;
int ret;

	if(argc == 1)
	{
		printf("\n%s\n\n",blurb);
		return(0); /* Nothing else to do so exit */
	}	
	else
	{
	
		/*** Rev 1.1 handle '+' arguments to p2c ***/
		/* First extract command line switch settings to send to p2c */
		clearStr(p2copts);
	
		clearStr(optstring);

		for(x = 1;x < argc; x++)
		{
			if(strcmp(argv[x],"+s") == 0)
			{
				/* If we have a +s option for p2c it will
				 * have a file name following it
				 * so change +s to -s and pass to p2c then
				 * point to the following parm and concatenate
				 * to the options string.
				 */ 
				strcat(p2copts,"-s ");
				strcpy(argv[x],"");
				x++;
				strcat(p2copts,argv[x]);
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+v") == 0)
			{
				strcat(p2copts,"-v ");
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+H") == 0)
			{
				/* If we have a +H option it will have a 
				 * a directory name following it.
				 */
				strcat(p2copts,"-H ");
				strcpy(argv[x],"");
				x++;
				strcat(p2copts,argv[x]);
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+q") == 0)
			{
				strcat(p2copts,"-q ");
				strcpy(argv[x],"");
			}
			if(strncmp(argv[x],"+E",2) == 0)
			{
				/* If we have a +E option we also pass a 
				 * number to p2c. So first we pass the 
				 * argument string then change + to -.
				 * Then we erase the argument
				 */
				strcat(p2copts,argv[x]);
				strcat(p2copts," "); /* Add final space */
				p2copts[(strlen(p2copts) - strlen(argv[x]) -1)] = 0x2d;
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+e") == 0)
			{
				strcat(p2copts,"-e ");
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+L") == 0)
			{
				/* If we have a +L option we also pass "turbo"
				 * etc. to p2c.
				 */
				strcat(p2copts,"-L ");
				strcpy(argv[x],"");
				x++;
				strcat(p2copts,argv[x]);
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+V") == 0)
			{
				strcat(p2copts,"-V");
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+M0") == 0)
			{
				strcat(p2copts,"-M0");
				strcpy(argv[x],"");
			}
			if(strcmp(argv[x],"+R") == 0)
			{
				strcat(p2copts,"-R");
				strcpy(argv[x],"");
			}
		}
		/*** End of Rev 1.1 ***/	

		/* We don't know if the line has a -o flag in it yet, so: */

		clearStr(ostring);
		oflag = FALSE ;

		/* We don't know if line has a -c flag in it yet so: */

		compileOnly = FALSE ;
				
		for(x = 1; x < argc; x++)
		{

		/* We check for a "-c" option in the command line, setting the
		 * compileOnly flag if there is one.
		 */
		 
			if(strcmp(argv[x],"-c") == 0)
			{
				compileOnly = TRUE;
			}

			/* Next we handle the case of a "-o" flag in line */
			
			if(strcmp(argv[x],"-o") == 0)
			{
				strcpy(ostring,"-o ");
				strcat(ostring, argv[x+1]);
				oflag = TRUE ;
			}
			else
			{
				/* If this is an argument add to optstring */
				if(strncmp(argv[x],"-",1)==0)
				{
					strcat(optstring,argv[x]);
					strcat(optstring," ");
				} 
			}
		}
		
		for(x = 1; x < argc; x++)
		{
		
		/* If we have a "-o" in line ignore switch and argument */

			if(strcmp(argv[x],"-o") == 0)
			{
				x++;
				x++;
				/*** rev 1.3 mod ***/
				if(x >= argc) break;
				/*** end 1.3 mod ***/
			}

			/* Next we ignore other command switch arguments */
			if(!strncmp(argv[x],"-",1) == 0) 
			{

			/* If not a switch then check for .p file */
				strcpy(temp,argv[x]);
				if((temp[strlen(temp)-1] == typeIden) && (temp[strlen(temp) -2] == '.'))
				{
					strcpy(thisArg,xlat);
					strcat(thisArg," ");
					/*** Rev 1.1 mods ***/
					strcat(thisArg,p2copts);
					strcat(thisArg," ");
					/*** End of Rev 1.1 mods ***/
					strcat(thisArg,argv[x]);
					system(thisArg) ;

					if(!oflag)
					{
						strcpy(ccstring,cc);
						strcat(ccstring,INCLD);
						/*** Rev 1.1 mods ***/	
						/* Now add in the option string */

						strcat(ccstring," ");
						strcat(ccstring,optstring);
						strcat(ccstring," ");
						/*** End of Rev 1.1 mods ***/
						
						/* Now change name of .p file to .c */
						clearStr(cfile);
						strncpy(cfile,argv[x],(strlen(argv[x]) -1));
	
						/* Now get rid of the the . at the end of the name */
		
						clearStr(filename);
						strncpy(filename,cfile,(strlen(cfile) -1));
						strcat(cfile,"c");
						strcat(ccstring,cfile);
						strcat(ccstring," ");

						/* Now construct the output file name 
						 * providing there was no "-c" switch in the
						 * command line
						 */
	
						if(!compileOnly)
						{ 
							strcat(ccstring,LIBR);
							strcat(ccstring,"-o ");
							strcat(ccstring,filename);
						}
							/* Now issue the gcc command line */
						system(ccstring) ;
						/* Now erase the .c files */
						strcpy(rmstring,"rm -f ");
						strcat(rmstring,cfile);
						system(rmstring);
							
						/* Now erase the .o file if there was no -c flag */
						
						if(!compileOnly)
						{
							strcpy(rmstring,"rm -f ");
							strcat(rmstring,filename);
							strcat(rmstring,".o");
							system(rmstring);
						}	
						/* Now erase the .h files */
							strcpy(rmstring,"rm -f ");
							strcat(rmstring,filename);
							strcat(rmstring,".h");
							system(rmstring);
						/*** Rev 1.2 Erase .log files ***/
							strcpy(rmstring,"rm -f ");
							strcat(rmstring,filename);
							strcat(rmstring,".log");
							system(rmstring);
						/*** End Rev 1.2 ***/
							
					}
				}				
			}
		}
		/* Now we check for "-o" switch and if it is there we form
		 * a single gcc command line to handle possible separate
		 * source files joined into one executable file
		 */
		if(oflag) 
		{
			strcpy(ccstring,"gcc ");
			strcat(ccstring,INCLD);
			strcat(ccstring," ");
			
			/* Now add in the option string */

			strcat(ccstring," ");
			strcat(ccstring,optstring);
			strcat(ccstring," ");
			

			/* Now we start building the rm strings. 
			 * We use the -f flag in the strings to remove
			 * the .c and .h files that p2c produces because we
			 * don't want rm to bother the user with something like:
			 *
			 *      /bin/rm foo.h file does not exist
			 *
			 * if p2c didn't make the .h or .c file for a given file name
			 */
			 			
			strcpy(rmstring,"rm -f ");
			strcpy(rmhstring,"rm -f ");
			
			/*** Rev 1.2 mod ***/
			strcpy(rmlstring,"rm -f ");
			/*** End of 1.2 mod ***/
			
			/* Now change name of .p file to .c */

			for(x = 1; x < argc; x++)
			{
				if(strncmp(argv[x],"-",1) != 0)
				{ 
					strcpy(temp,argv[x]);
					if((temp[strlen(temp)-1] == typeIden) && (temp[strlen(temp) -2] == '.'))
					{
						clearStr(cfile);
						strncpy(cfile,argv[x],(strlen(argv[x]) -1));
						strcat(cfile,"c");
						strcat(ccstring,cfile);
						strcat(ccstring," ");

						/* As long as we are here build the
						 * rm strings also
						 */

						strcat(rmstring,cfile);
						strcat(rmstring," ");
						clearStr(cfile);
						strncpy(cfile,argv[x],(strlen(argv[x]) -1));
						strcat(rmhstring,cfile);
						strcat(rmhstring,"h ");
						
						/*** Rev 1.2 mod ***/
						strcat(rmlstring,cfile);
						strcat(rmlstring,"log ");
						/*** End of Rev 1.2 mod ***/
					}
					else
					{
						strcat(ccstring,argv[x]);
						strcat(ccstring," ");
					}
				}
				/*** Rev 1.3 mod ***/
				if(strcmp(argv[x],"-o") == 0)
				{
					x++;
				}
			}
			/* Add in the library specifier */
			
			strcat(ccstring,LIBR);

			/* Now construct the -o filename option on line */

			strcat(ccstring,ostring) ;
			
			/* Now issue the gcc command line */

			system(ccstring) ;

			/* Now erase the .c and the .h files (Rev 1.2 and also the .log) that p2c produces */

			system(rmstring);
			system(rmhstring);
			
			/*** Rev 1.2 mod ***/
			system(rmlstring);
			/*** End of Rev 1.2 mod ***/
		}

	}
	return(0) ;
}
