#line 1 "ascfiler.m"
struct _PRIVATE { struct _PRIVATE *isa; };
typedef struct _PRIVATE *id;
struct _SHARED {
  id isa;
  id clsSuper;
  char *clsName;
  char *clsTypes;
  short clsSizInstance;
  short clsSizDict;
  struct _SLT *clsDispTable;
  long clsStatus;
  struct modDescriptor *clsMod;
  unsigned clsVersion;
  id clsCats;
  id *clsGlbl;
};
extern id  (* _imp(id,char*))();
extern id  (* _impSuper(id,char*))();
extern struct modDescriptor  *_OBJCBIND_ascfiler(void);
static char **selTransTbl;
struct _SLT {char *_cmd;id (*_imp)();};
struct modDescriptor {
  char *modName;
  char *modVersion;
  long modStatus;
  char *modMinSel;
  char *modMaxSel;
  id *modClsLst;
  short modSelRef;
  char **modSelTbl;
  struct methodDescriptor *modMapTbl;
};
extern struct modDescriptor ascfiler_modDesc;

#line 1 "../../util//stdarg.h"
#include <stdarg.h>

#line 1 "../../util//stdio.h"
#include <stdio.h>

#line 1 "../../util//stdio.h"
#include <stdio.h>

#line 1 "../../util//stddef.h"
#include <stddef.h>

#line 53 "../../include/objcrt/objcrt.h"
typedef char*SEL;
typedef char*STR;
typedef char BOOL;
typedef FILE*IOD;
typedef id SHR;
#line 62 "../../include/objcrt/objcrt.h"
typedef id(*IMP)();


typedef void(*ARGIMP)(id,SEL,void*);
#line 85 "../../include/objcrt/objcrt.h"
extern BOOL msgFlag;
extern FILE*msgIOD;
extern FILE*dbgIOD;
extern BOOL allocFlag;
extern BOOL dbgFlag;
extern BOOL noCacheFlag;
extern BOOL noNilRcvr;
#line 98 "../../include/objcrt/objcrt.h"
SEL selUid(STR);
STR selName(SEL);
void dbg(char*fmt,...);
void prnstack(FILE*file);
void loadobjc(void*modPtr);
void unloadobjc(void*modPtr);
#line 107 "../../include/objcrt/objcrt.h"
IMP fwdimp(id,SEL,IMP);
IMP fwdimpSuper(id,SEL,IMP);
void fwdmsg(id,SEL,void*,ARGIMP);
id selptrfwd(id,SEL,id,id,id,id);


id idincref(id obj);
id idassign(id*lhs,id rhs);
id iddecref(id obj);

extern id(*_fileIn)(FILE*);
extern BOOL(*_fileOut)(FILE*,id);
extern BOOL(*_storeOn)(STR,id);
extern id(*_readFrom)(STR);
void setfilein(id(*f)(FILE*));
void setfileout(BOOL(*f)(FILE*,id));

extern id(*_showOn)(id,unsigned);

void*OC_Malloc(size_t);
void*OC_MallocAtomic(size_t);
void*OC_Calloc(size_t);
void*OC_Realloc(void*,size_t);
void*OC_Free(void*data);
#line 1 "../../util//string.h"
#include <string.h>

#line 31 "ordcltn.h"
typedef struct objcol
{
int count;
int capacity;
id*ptr;
}*
objcol_t;
#line 1 "../../util//string.h"
#include <string.h>

#line 1 "../../util//assert.h"
#include <assert.h>

#line 1 "../../util//stdlib.h"
#include <stdlib.h>

#line 34 "ascfiler.h"
struct AsciiFiler_PRIVATE {

#line 42 "../../include/objcrt/Object.h"
id isa;
#line 46 "../../include/objcrt/Object.h"
unsigned short attr;
unsigned short objID;
#line 36 "ascfiler.h"
FILE*file;
BOOL ownFile;
BOOL inSecondPass;
id toc;
void**patchPointers;
int patchSize;
int patchCapacity;};

#line 34 "ascfiler.h"
extern id  AsciiFiler;

#line 34 "ascfiler.h"
extern struct _SHARED _AsciiFiler;
extern struct _SHARED __AsciiFiler;


#line 39 "ascfiler.m"
static BOOL
asciiFileOut(FILE*f,id anObject)
{
id objcT0,objcT1,objcT2;

#line 42 "ascfiler.m"
BOOL r;
id aFiler=(objcT0=AsciiFiler,(*_imp(objcT0,selTransTbl[0]))(objcT0,selTransTbl[0]));
r=(objcT1=aFiler,(*(BOOL(*)(id,SEL,id,FILE*))_imp(objcT1,selTransTbl[1]))(objcT1,selTransTbl[1],anObject,f));

(objcT2=aFiler,(*_imp(objcT2,selTransTbl[2]))(objcT2,selTransTbl[2]));

return r;
}

static id
asciiFileIn(FILE*f)
{
id objcT3,objcT4,objcT5;

#line 54 "ascfiler.m"
id r;
id aFiler=(objcT3=AsciiFiler,(*_imp(objcT3,selTransTbl[0]))(objcT3,selTransTbl[0]));
r=(objcT4=aFiler,(*(id(*)(id,SEL,FILE*))_imp(objcT4,selTransTbl[3]))(objcT4,selTransTbl[3],f));

(objcT5=aFiler,(*_imp(objcT5,selTransTbl[2]))(objcT5,selTransTbl[2]));

return r;
}

static id c_AsciiFiler_initialize(struct AsciiFiler_PRIVATE *self,SEL _cmd)
{
setfilein(asciiFileIn);
setfileout(asciiFileOut);
return(id)self;
}

#line 77 "ascfiler.m"
static id c_AsciiFiler_new(struct AsciiFiler_PRIVATE *self,SEL _cmd)
{
id objcT6;

#line 79 "ascfiler.m"
return(objcT6=__AsciiFiler.clsSuper,(*_impSuper(objcT6,selTransTbl[0]))((id)self,selTransTbl[0]));
}

static id i_AsciiFiler_free(struct AsciiFiler_PRIVATE *self,SEL _cmd)
{
id objcT7;

#line 84 "ascfiler.m"
if(self->ownFile)
{
fclose(self->file);
}
return(objcT7=_AsciiFiler.clsSuper,(*_impSuper(objcT7,selTransTbl[2]))((id)self,selTransTbl[2]));
}

#line 98 "ascfiler.m"
static BOOL i_AsciiFiler_store_on_(struct AsciiFiler_PRIVATE *self,SEL _cmd,id anObject,STR aFileName)
{
BOOL r;

if((self->file=fopen(aFileName,"w")))
{
id objcT8;
self->
#line 104 "ascfiler.m"
ownFile=(BOOL)1;
r=(objcT8=(id)self,(*(BOOL(*)(id,SEL,id,FILE*))_imp(objcT8,selTransTbl[1]))(objcT8,selTransTbl[1],anObject,self->file));
if(self->ownFile)
{self->
ownFile=(BOOL)0;
fclose(self->file);
}
}
else
{
r=(BOOL)0;
}

return r;
}

static id i_AsciiFiler_readFrom_(struct AsciiFiler_PRIVATE *self,SEL _cmd,STR aFileName)
{
id r;

if((self->file=fopen(aFileName,"r")))
{
id objcT9;
self->
#line 126 "ascfiler.m"
ownFile=(BOOL)1;
r=(objcT9=(id)self,(*(id(*)(id,SEL,FILE*))_imp(objcT9,selTransTbl[3]))(objcT9,selTransTbl[3],self->file));
if(self->ownFile)
{self->
ownFile=(BOOL)0;
fclose(self->file);
}
}
else
{
r=(id)0;
}

return r;
}

#line 160 "ascfiler.m"
static BOOL
isClass(id anObject)
{
id objcT10;

#line 163 "ascfiler.m"
return anObject!=(id)0&&(objcT10=anObject,(*_imp(objcT10,selTransTbl[4]))(objcT10,selTransTbl[4]))==anObject;
}

#line 39 "ordcltn.h"
extern id  OrdCltn;

#line 166 "ascfiler.m"
static BOOL i_AsciiFiler_store_onFile_(struct AsciiFiler_PRIVATE *self,SEL _cmd,id anObject,FILE*aFile)
{
id objcT11,objcT12,objcT13,objcT14,objcT17;

#line 168 "ascfiler.m"
int i,n;self->

file=aFile;


fprintf(self->file,"#%s i%d \n",(objcT11=(id)self,(*(STR(*)(id,SEL))_imp(objcT11,selTransTbl[5]))(objcT11,selTransTbl[5])),317);self->


inSecondPass=(BOOL)0;self->
toc=(objcT12=OrdCltn,(*_imp(objcT12,selTransTbl[0]))(objcT12,selTransTbl[0]));
(objcT13=(id)self,(*_imp(objcT13,selTransTbl[6]))(objcT13,selTransTbl[6],anObject));self->
#line 182 "ascfiler.m"
inSecondPass=(BOOL)1;
for(i=0,n=(objcT14=self->toc,(*(unsigned(*)(id,SEL))_imp(objcT14,selTransTbl[7]))(objcT14,selTransTbl[7]));i<n;i++)
{
id objcT15,objcT16;


fprintf(self->file,"%i ",i+1);

(objcT15=(objcT16=self->toc,(*(id(*)(id,SEL,unsigned))_imp(objcT16,selTransTbl[8]))(objcT16,selTransTbl[8],i)),(*_imp(objcT15,selTransTbl[9]))(objcT15,selTransTbl[9],(id)self));
fprintf(self->file,"\n");
}self->


inSecondPass=(BOOL)0;self->

toc=(objcT17=self->toc,(*_imp(objcT17,selTransTbl[2]))(objcT17,selTransTbl[2]));
#line 202 "ascfiler.m"
return(BOOL)1;
}

static void
outClass(FILE*file,void*value)
{
id objcT18;

#line 208 "ascfiler.m"
id aClass= *((id*)value);
fprintf(file,"#%s ",(objcT18=aClass,(*(STR(*)(id,SEL))_imp(objcT18,selTransTbl[5]))(objcT18,selTransTbl[5])));
}

static void
outObject(id self,FILE*file,id toc,void*value)
{
id anObject= *((id*)value);


if(isClass(anObject))
{
id objcT19;

#line 220 "ascfiler.m"
(objcT19=self,(*(id(*)(id,SEL,void*,char))_imp(objcT19,selTransTbl[10]))(objcT19,selTransTbl[10],value,'#'));
return;
}

if(anObject)
{
id objcT20,objcT21;

#line 226 "ascfiler.m"
int offset=(objcT20=toc,(*(unsigned(*)(id,SEL,id))_imp(objcT20,selTransTbl[11]))(objcT20,selTransTbl[11],anObject));
if(offset== -1)
(objcT21=self,(*(id(*)(id,SEL,STR,...))_imp(objcT21,selTransTbl[12]))(objcT21,selTransTbl[12],"AsciiFiler : offset error"));
fprintf(file,"@%i ",offset+1);
}
else
{
fprintf(file,"@0 ");
}
}

static void
outChar(FILE*file,void*value)
{
char c= *((char*)value);
fprintf(file,"c%c ",c);
}

static void
outInt(FILE*file,void*value)
{
int i= *((int*)value);
fprintf(file,"i%i ",i);
}

static void
outUShort(FILE*file,void*value)
{
unsigned i= *((unsigned short*)value);
fprintf(file,"S%u ",i);
}

static void
outShort(FILE*file,void*value)
{
int i= *((short*)value);
fprintf(file,"s%i ",i);
}

static void
outfloat(FILE*file,void*value)
{
float f= *((float*)value);
fprintf(file,"f%f ",f);
}

static void
outdouble(FILE*file,void*value)
{
double d= *((double*)value);
fprintf(file,"d%f ",d);
}

#line 283 "ascfiler.m"
static void
outSTR(FILE*file,void*value)
{
STR s;
int len;

s= *((STR*)value);

if(s)
{
len=strlen(s);
fprintf(file,"*%i\"%s ",len,s);
}
else
{
fprintf(file,"%c0 ",044);
}
}

static id i_AsciiFiler_fileOut2_type_(struct AsciiFiler_PRIVATE *self,SEL _cmd,void*value,char typeDesc)
{
switch(typeDesc)
{
case'#':outClass(self->file,value);
break;
case'@':
outObject((id)self,self->file,self->toc,value);
break;
case'c':
outChar(self->file,value);
break;
case'i':
outInt(self->file,value);
break;
case's':
outShort(self->file,value);
break;
case'S':
outUShort(self->file,value);
break;
case'f':
outfloat(self->file,value);
break;
case'd':
outdouble(self->file,value);
break;
case'*':
outSTR(self->file,value);
break;
case 044:
fprintf(self->file,"%c0 ",044);
break;
default:
{
id objcT22;

#line 337 "ascfiler.m"
(objcT22=(id)self,(*(id(*)(id,SEL,STR,...))_imp(objcT22,selTransTbl[12]))(objcT22,selTransTbl[12],"Asciifiler: unknown type descriptor '%c'",typeDesc));
break;
}
}

return(id)self;
}

static id i_AsciiFiler_fileOutObject_(struct AsciiFiler_PRIVATE *self,SEL _cmd,id anObject)
{
id objcT23;

#line 347 "ascfiler.m"
if(anObject!=(id)0&& !isClass(anObject)&&(objcT23=self->toc,(*_imp(objcT23,selTransTbl[13]))(objcT23,selTransTbl[13],anObject))==(id)0)
{
id objcT24,objcT25;

#line 349 "ascfiler.m"
(objcT24=self->toc,(*_imp(objcT24,selTransTbl[14]))(objcT24,selTransTbl[14],anObject));
(objcT25=anObject,(*_imp(objcT25,selTransTbl[9]))(objcT25,selTransTbl[9],(id)self));
}

return(id)self;
}

static id i_AsciiFiler_fileOut_type_(struct AsciiFiler_PRIVATE *self,SEL _cmd,void*value,char typeDesc)
{
id objcT26;

#line 358 "ascfiler.m"
if(self->inSecondPass)
return(objcT26=(id)self,(*(id(*)(id,SEL,void*,char))_imp(objcT26,selTransTbl[10]))(objcT26,selTransTbl[10],value,typeDesc));

if(typeDesc=='@')
{
id objcT27;

#line 363 "ascfiler.m"
id anObject= *((id*)value);
return(objcT27=(id)self,(*_imp(objcT27,selTransTbl[6]))(objcT27,selTransTbl[6],anObject));
}

return(id)self;
}
#line 377 "ascfiler.m"
static char changeErr[]="Asciifiler: type inconsistency :want '%c' got '%c'";

static int
nextCode(FILE*file)
{
int code;
do
{
code=getc(file);
}
while(code==' '||code=='\t');
return code;
}



static int
lex(id self,FILE*file,int expected,char*buffer)
{
int code=nextCode(file);
char*q=buffer;

switch(code)
{
case'c':
case'i':
case's':
case'S':
case'f':
case'd':
case'@':
case'#':
{
int c;
while((c=getc(file))!=' ') *
q++=c; *
q=0;
break;
}
default:
break;
}

if(code==044)
return code;

if(code==expected)
{
#line 439 "ascfiler.m"
return code;
}
else
{
id objcT28;

#line 443 "ascfiler.m"
(objcT28=self,(*(id(*)(id,SEL,STR,...))_imp(objcT28,selTransTbl[12]))(objcT28,selTransTbl[12],changeErr,expected,code));
return 0;
}
}

static int
a_to_i(char*s)
{
return atoi(s);
}

static double
a_to_f(char*s)
{
return atof(s);
}

static int
skipIX(FILE*file)
{
int c;
while(feof(file)==0&&(c=getc(file))!=' ')
{
#line 469 "ascfiler.m"
}
return 0==feof(file);
}

static STR
lexSTR(id self,FILE*file)
{
int expected='*';
int code=nextCode(file);

if(code==044)
{
skipIX(file);
return NULL;
}

if(code!=expected)
{
id objcT29;

#line 487 "ascfiler.m"
(objcT29=self,(*(id(*)(id,SEL,STR,...))_imp(objcT29,selTransTbl[12]))(objcT29,selTransTbl[12],changeErr,expected,code));
return NULL;
}
else
{
STR q;
STR s;
int c,len;
char buffer[32];

q=buffer;
while((c=getc(file))!='\"') *
q++=c; *
q=0;
len=a_to_i(buffer);
s=OC_Malloc(len+1);
q=s;
while(len--) *
q++=getc(file); *
q++=0;
#line 511 "ascfiler.m"
return s;
}
}

static id
lexClass(id self,FILE*file)
{
id objcT30;

#line 518 "ascfiler.m"
char buffer[1024];
lex(self,file,'#',buffer);
return(objcT30=self,(*(id(*)(id,SEL,STR))_imp(objcT30,selTransTbl[15]))(objcT30,selTransTbl[15],buffer));
}

static int
lexObjectOffset(id self,FILE*file)
{
char buffer[32];
lex(self,file,'@',buffer);
return a_to_i(buffer);
}

static int
lexChar(id self,FILE*file)
{
char buffer[8];
lex(self,file,'c',buffer);
return buffer[0];
}

static short int
lexShort(id self,FILE*file)
{
char buffer[32];
lex(self,file,'s',buffer);
return a_to_i(buffer);
}

static unsigned short int
lexUShort(id self,FILE*file)
{
char buffer[32];
lex(self,file,'S',buffer);
return a_to_i(buffer);
}

static int
lexInt(id self,FILE*file)
{
char buffer[32];
lex(self,file,'i',buffer);
return a_to_i(buffer);
}

static float
lexfloat(id self,FILE*file)
{
char buffer[32];
lex(self,file,'f',buffer);
return a_to_f(buffer);
}

static float
lexdouble(id self,FILE*file)
{
char buffer[32];
lex(self,file,'d',buffer);
return a_to_f(buffer);
}


static void
skipNL(id self,FILE*file)
{
lex(self,file,'\n',NULL);
}

static id i_AsciiFiler_readFromFile_(struct AsciiFiler_PRIVATE *self,SEL _cmd,FILE*aFile)
{
id objcT31,objcT33,objcT39,objcT40,objcT41;
id objcT42,objcT43;

#line 588 "ascfiler.m"
id anObject;
int i,n,version;self->

file=aFile;


if(self->isa!=lexClass((id)self,self->file))
(objcT31=(id)self,(*(id(*)(id,SEL,STR,...))_imp(objcT31,selTransTbl[12]))(objcT31,selTransTbl[12],"Asciifiler: wrong filer"));
version=lexInt((id)self,self->file);
if(version!=317)
{
id objcT32;

#line 599 "ascfiler.m"
STR msg="AsciiFiler '%d': input is in '%d' format";
return(objcT32=(id)self,(*(id(*)(id,SEL,STR,...))_imp(objcT32,selTransTbl[12]))(objcT32,selTransTbl[12],msg,317,version));
}

skipNL((id)self,self->file);self->

toc=(objcT33=OrdCltn,(*_imp(objcT33,selTransTbl[0]))(objcT33,selTransTbl[0]));self->
patchSize=0;self->
patchCapacity=16;self->
patchPointers=(void**)OC_Malloc(sizeof(void*)*self->patchCapacity);
#line 616 "ascfiler.m"
while(feof(self->file)==0&&skipIX(self->file))
{
id objcT34,objcT35;

#line 618 "ascfiler.m"
id aClass=lexClass((id)self,self->file);
anObject=(objcT34=aClass,(*_imp(objcT34,selTransTbl[16]))(objcT34,selTransTbl[16],(id)self));
(objcT35=self->toc,(*_imp(objcT35,selTransTbl[14]))(objcT35,selTransTbl[14],anObject));
skipNL((id)self,self->file);
}
#line 626 "ascfiler.m"
for(i=0;i<self->patchSize;i++)
{
id objcT36,objcT38;

#line 628 "ascfiler.m"
int offset;
void*value=self->patchPointers[i];
offset= *((int*)value);
if(offset>(objcT36=self->toc,(*(unsigned(*)(id,SEL))_imp(objcT36,selTransTbl[7]))(objcT36,selTransTbl[7])))
{
id objcT37;

#line 633 "ascfiler.m"
(objcT37=(id)self,(*(id(*)(id,SEL,STR,...))_imp(objcT37,selTransTbl[12]))(objcT37,selTransTbl[12],"AsciiFiler : offset error"));
} *
((id*)value)=(offset)?(objcT38=self->toc,(*(id(*)(id,SEL,unsigned))_imp(objcT38,selTransTbl[8]))(objcT38,selTransTbl[8],offset-1)):(id)0;
}
#line 640 "ascfiler.m"
for(i=0,n=(objcT39=self->toc,(*(unsigned(*)(id,SEL))_imp(objcT39,selTransTbl[7]))(objcT39,selTransTbl[7]));i<n;i++)
(objcT40=(objcT41=self->toc,(*(id(*)(id,SEL,unsigned))_imp(objcT41,selTransTbl[8]))(objcT41,selTransTbl[8],i)),(*_imp(objcT40,selTransTbl[17]))(objcT40,selTransTbl[17],(id)self));
#line 645 "ascfiler.m"
anObject=(objcT42=self->toc,(*_imp(objcT42,selTransTbl[18]))(objcT42,selTransTbl[18]));
OC_Free(self->patchPointers);self->
patchPointers=NULL;self->

toc=(objcT43=self->toc,(*_imp(objcT43,selTransTbl[2]))(objcT43,selTransTbl[2]));


return anObject;
}

static id i_AsciiFiler_fileIn_type_(struct AsciiFiler_PRIVATE *self,SEL _cmd,void*value,char typeDesc)
{
switch(typeDesc)
{
case'#':
{ *
((id*)value)=lexClass((id)self,self->file);
break;
}
case'@':
{
id objcT44;

#line 666 "ascfiler.m"
int offset;
offset=lexObjectOffset((id)self,self->file);
if(offset<=(objcT44=self->toc,(*(unsigned(*)(id,SEL))_imp(objcT44,selTransTbl[7]))(objcT44,selTransTbl[7])))
{
id objcT45;
 *
#line 670 "ascfiler.m"
((id*)value)=(offset)?(objcT45=self->toc,(*(id(*)(id,SEL,unsigned))_imp(objcT45,selTransTbl[8]))(objcT45,selTransTbl[8],offset-1)):(id)0;
}
else
{ *

((int*)value)=offset;
if(self->patchSize==self->patchCapacity)
{self->
patchCapacity=self->patchCapacity*2+1;self->
patchPointers=(void**)OC_Realloc(self->patchPointers,self->patchCapacity);
}self->

patchPointers[self->patchSize]=value;self->
patchSize++;
}
break;
}
case'c':
{ *
((char*)value)=lexChar((id)self,self->file);
break;
}
case'i':
{ *
((int*)value)=lexInt((id)self,self->file);
break;
}
case's':
{ *
((short*)value)=lexShort((id)self,self->file);
break;
}
case'S':
{ *
((unsigned short*)value)=lexUShort((id)self,self->file);
break;
}
case'f':
{ *
((float*)value)=lexfloat((id)self,self->file);
break;
}
case'd':
{ *
((double*)value)=lexdouble((id)self,self->file);
break;
}
case'*':
{ *
((STR*)value)=lexSTR((id)self,self->file);
break;
}
case 044:
{ *
((void**)value)=NULL;
skipIX(self->file);
break;
}
default:
{
id objcT46;

#line 730 "ascfiler.m"
(objcT46=(id)self,(*(id(*)(id,SEL,STR,...))_imp(objcT46,selTransTbl[12]))(objcT46,selTransTbl[12],"Asciifiler: unknown type descriptor '%c'",typeDesc));
break;
}
}

return(id)self;
}
extern id  Object;
extern struct _SHARED _Object;
extern struct _SHARED __Object;
static struct _SLT _AsciiFiler_clsDispatchTbl[] ={
{"initialize",(id (*)())c_AsciiFiler_initialize},
{"new",(id (*)())c_AsciiFiler_new},
{(char*)0,(id (*)())0}
};
static struct _SLT _AsciiFiler_nstDispatchTbl[] ={
{"free",(id (*)())i_AsciiFiler_free},
{"store:on:",(id (*)())i_AsciiFiler_store_on_},
{"readFrom:",(id (*)())i_AsciiFiler_readFrom_},
{"store:onFile:",(id (*)())i_AsciiFiler_store_onFile_},
{"fileOut2:type:",(id (*)())i_AsciiFiler_fileOut2_type_},
{"fileOutObject:",(id (*)())i_AsciiFiler_fileOutObject_},
{"fileOut:type:",(id (*)())i_AsciiFiler_fileOut_type_},
{"readFromFile:",(id (*)())i_AsciiFiler_readFromFile_},
{"fileIn:type:",(id (*)())i_AsciiFiler_fileIn_type_},
{(char*)0,(id (*)())0}
};
id AsciiFiler = (id)&_AsciiFiler;
id  *OBJCCLASS_AsciiFiler(void) { return &AsciiFiler; }
struct _SHARED  _AsciiFiler = {
  (id)&__AsciiFiler,
  (id)&_Object,
  "AsciiFiler",
  0,
  sizeof(struct AsciiFiler_PRIVATE),
  9,
  _AsciiFiler_nstDispatchTbl,
  41,
  &ascfiler_modDesc,
  0,
  (id)0,
  &AsciiFiler,
};
id  OBJCCFUNC_AsciiFiler(void) { return (id)&_AsciiFiler; }
id  OBJCCSUPER_AsciiFiler(void) { return _AsciiFiler.clsSuper; }
struct _SHARED __AsciiFiler = {
  (id)&__Object,
  (id)&__Object,
  "AsciiFiler",
  0,
  sizeof(struct _SHARED),
  2,
  _AsciiFiler_clsDispatchTbl,
  34,
  &ascfiler_modDesc,
  0,
  (id)0,
  0,
};
id  OBJCMFUNC_AsciiFiler(void) { return (id)&__AsciiFiler; }
id  OBJCMSUPER_AsciiFiler(void) { return __AsciiFiler.clsSuper; }
static char *_selTransTbl[] ={
"new",
"store:onFile:",
"free",
"readFromFile:",
"class",
"name",
"fileOutObject:",
"size",
"at:",
"fileOutOn:",
"fileOut2:type:",
"offsetOf:",
"error:",
"find:",
"add:",
"idOfSTR:",
"fileInFrom:",
"awakeFrom:",
"firstElement",
0
};
struct modDescriptor ascfiler_modDesc = {
  "ascfiler",
  "objc3.1.27",
  0L,
  0,
  0,
  &AsciiFiler,
  19,
  _selTransTbl,
  0
};
struct modDescriptor *_OBJCBIND_ascfiler(void)
{
  selTransTbl = _selTransTbl;
  return &ascfiler_modDesc;
}
int _OBJCPOSTLINK_ascfiler = 1;


