
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: GradientFillMorph.h,v 1.3 1999/06/01 22:08:03 stes Exp $
 */

#ifndef __GRADIENTFILLMORPH_H__

#include <RectangleMorph.h>

@interface GradientFillMorph : RectangleMorph
{
  id fillColor2;
  id gradientDirection;
  id colorArray;
  id colorDepth;
}

/* initialize */

- changed;
- initialize;

/* drawing */

- drawOn:aCanvas;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- beHorizontal;
- beVertical;
- gradientDirection;

/* private */

- colorArrayForDepth:aDepth;
- loadCachedState;
- releaseCachedState;
- stepSize;

- gradientFillColor:aColor;
- (BOOL)hasTranslucentColor;
- setGradientColor:aColor;

@end
 
#define __GRADIENTFILLMORPH_H__
#endif

