
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: SketchEditorMorph.m,v 1.3 1999/05/26 18:05:32 stes Exp $
 */

#include "SketchEditorMorph.h"

@implementation SketchEditorMorph

/* class methods */

+ (BOOL)includeInNewMorphMenu { [self notImplemented]; }

/* initialization */

- initializeFor:aSketchMorph inBounds:boundsToUse pasteUpMorph:aPasteUpMorph { [self notImplemented]; }
- initializeFor:aSketchMorph inBounds:boundsToUse pasteUpMorph:aPasteUpMorph paintBoxPosition:aPosition { [self notImplemented]; }

/* morphic */

- drawOn:aCanvas { [self notImplemented]; }
- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- mouseDown:evt { [self notImplemented]; }
- mouseEnter:evt { [self notImplemented]; }
- mouseEnterDragging:evt { [self notImplemented]; }
- mouseLeave:evt { [self notImplemented]; }
- mouseLeaveDragging:evt { [self notImplemented]; }
- mouseMove:evt { [self notImplemented]; }
- mouseUp:evt { [self notImplemented]; }

/* access */

- currentColor { [self notImplemented]; }
- currentColor:cc { [self notImplemented]; }
- forwardDirection { [self notImplemented]; }
- hostView { [self notImplemented]; }
- painting { [self notImplemented]; }
- palette { [self notImplemented]; }
- registrationPoint { [self notImplemented]; }
- registrationPoint:aPoint { [self notImplemented]; }
- rotationStyle { [self notImplemented]; }
- save:aForm { [self notImplemented]; }
- ticksToDwell { [self notImplemented]; }
- ticksToDwell:t { [self notImplemented]; }

/* start & finish */

- addRotationScaleHandles { [self notImplemented]; }
- afterNewPicDo:goodBlock ifNoBits:badBlock { [self notImplemented]; }
- cancel { [self notImplemented]; }
- cancelOutOfPainting { [self notImplemented]; }
- deliverPainting:result { [self notImplemented]; }
- dimTheWindow { [self notImplemented]; }
- (BOOL)handlesDragOver:evt { [self notImplemented]; }
- (BOOL)handlesMouseOver:evt { [self notImplemented]; }
- (BOOL)handlesMouseOverDragging:evt { [self notImplemented]; }
- prepareToPaint { [self notImplemented]; }
- save { [self notImplemented]; }
- setRotations:num { [self notImplemented]; }
- undo { [self notImplemented]; }
- verifyState { [self notImplemented]; }

/* actions & preps */

- areaFill:evt { [self notImplemented]; }
- brushAlphaFromGray { [self notImplemented]; }
- clear { [self notImplemented]; }
- ellipse:evt { [self notImplemented]; }
- erase:evt { [self notImplemented]; }
- erasePrep { [self notImplemented]; }
- fill:evt { [self notImplemented]; }
- flipHoriz:evt { [self notImplemented]; }
- flipVert:evt { [self notImplemented]; }
- line:evt { [self notImplemented]; }
- forward:evt direction:button { [self notImplemented]; }
- notes { [self notImplemented]; }
- paint:evt { [self notImplemented]; }
- pickup:evt { [self notImplemented]; }
- pickupMouseUp:evt { [self notImplemented]; }
- polyFreeze { [self notImplemented]; }
- polyNew:evt { [self notImplemented]; }
- polygon:evt { [self notImplemented]; }
- rect:evt { [self notImplemented]; }
- render:damageRect { [self notImplemented]; }
- replaceOnly:initialMousePoint { [self notImplemented]; }
- restoreRect:oldRect { [self notImplemented]; }
- rotateBy:evt { [self notImplemented]; }
- rotateDone:evt { [self notImplemented]; }
- rotateScalePrep { [self notImplemented]; }
- scaleBy:evt { [self notImplemented]; }
- showDirType { [self notImplemented]; }
- stamp:evt { [self notImplemented]; }
- star:evt { [self notImplemented]; }
- toggleDirType:evt in:handle { [self notImplemented]; }
- transBrush:evt { [self notImplemented]; }
- transBrushPrep { [self notImplemented]; }

/* copying */

- veryDeepFixupWith:deepCopier { [self notImplemented]; }
- veryDeepInner:deepCopier { [self notImplemented]; }

@end

