
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: SketchEditorMorph.h,v 1.3 1999/05/26 18:05:32 stes Exp $
 */

#ifndef __SKETCHEDITORMORPH_H__

#include <Morph.h>

@interface SketchEditorMorph : Morph
{
	id hostView;
	id stampForm;
	id canvasRectangle;
	id palette;
	id currentColor;
	id ticksToDwell;
	id rotationCenter;
	id registrationPoint;
	id newPicBlock;
	id emptyPicBlock;
	id action;
	id paintingForm;	
	id dimForm;
	id buff;
	id brush;
	id paintingFormPen;
	id formCanvas;
	id picToBuff;
	id brushToBuff;
	id buffToBuff;
	id buffToPic;
	id rotationButton;	
	id scaleButton;
	id strokeOrigin;
	id cumRot;
	id cumMag;
	id undoBuffer;
	id lastEvent;
	id currentNib;
	id enclosingPasteUpMorph;
}

/* class methods */

+ (BOOL)includeInNewMorphMenu;

/* initialization */

- initializeFor:aSketchMorph inBounds:boundsToUse pasteUpMorph:aPasteUpMorph;
- initializeFor:aSketchMorph inBounds:boundsToUse pasteUpMorph:aPasteUpMorph paintBoxPosition:aPosition;

/* morphic */

- drawOn:aCanvas;
- (BOOL)handlesMouseDown:evt;
- mouseDown:evt;
- mouseEnter:evt;
- mouseEnterDragging:evt;
- mouseLeave:evt;
- mouseLeaveDragging:evt;
- mouseMove:evt;
- mouseUp:evt;

/* access */

- currentColor;
- currentColor:cc;
- forwardDirection;
- hostView;
- painting;
- palette;
- registrationPoint;
- registrationPoint:aPoint;
- rotationStyle;
- save:aForm;
- ticksToDwell;
- ticksToDwell:t;

/* start & finish */

- addRotationScaleHandles;
- afterNewPicDo:goodBlock ifNoBits:badBlock;
- cancel;
- cancelOutOfPainting;
- deliverPainting:result;
- dimTheWindow;
- (BOOL)handlesDragOver:evt;
- (BOOL)handlesMouseOver:evt;
- (BOOL)handlesMouseOverDragging:evt;
- prepareToPaint;
- save;
- setRotations:num;
- undo;
- verifyState;

/* actions & preps */

- areaFill:evt;
- brushAlphaFromGray;
- clear;
- ellipse:evt;
- erase:evt;
- erasePrep;
- fill:evt;
- flipHoriz:evt;
- flipVert:evt;
- line:evt;
- forward:evt direction:button;
- notes;
- paint:evt;
- pickup:evt;
- pickupMouseUp:evt;
- polyFreeze;
- polyNew:evt;
- polygon:evt;
- rect:evt;
- render:damageRect;
- replaceOnly:initialMousePoint;
- restoreRect:oldRect;
- rotateBy:evt;
- rotateDone:evt;
- rotateScalePrep;
- scaleBy:evt;
- showDirType;
- stamp:evt;
- star:evt;
- toggleDirType:evt in:handle;
- transBrush:evt;
- transBrushPrep;

/* copying */

- veryDeepFixupWith:deepCopier;
- veryDeepInner:deepCopier;

@end
 
#define __SKETCHEDITORMORPH_H__
#endif

