
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PaintBoxMorph.m,v 1.2 1999/05/24 20:34:30 stes Exp $
 */

#include "PaintBoxMorph.h"

@implementation PaintBoxMorph

/* class methods */

+ fixUpPrototype { [self notImplemented]; }
+ flushPrototype { [self notImplemented]; }
+ new { [self notImplemented]; }
+ prototype { [self notImplemented]; }
+ releaseTemporaryForms { [self notImplemented]; }

/* initialization */

- createButtons { [self notImplemented]; }
- init3 { [self notImplemented]; }
- init4 { [self notImplemented]; }
- initialize { [self notImplemented]; }
- loadColorChooser { [self notImplemented]; }
- loadCursors { [self notImplemented]; }
- loadOnImage:(STR)filename { [self notImplemented]; }
- loadPressedImage:(STR)filename { [self notImplemented]; }
- loadRotScalePics { [self notImplemented]; }
- loadoffImage:(STR)filename { [self notImplemented]; }
- moveButtons { [self notImplemented]; }
- noVeneer { [self notImplemented]; }

/* other */

- colorMemory { [self notImplemented]; }
- colorMemory:aMorph { [self notImplemented]; }
- colorPatch { [self notImplemented]; }
- copyRecordingIn:dict { [self notImplemented]; }
- rotationTabForm { [self notImplemented]; }
- scaleTabForm { [self notImplemented]; }
- updateReferencesUsing:aDict { [self notImplemented]; }

/* actions */

- actionCursor { [self notImplemented]; }
- brush:brushButton action:aSel nib:aMask { [self notImplemented]; }
- (BOOL)brushable { [self notImplemented]; }
- clear:clearButton with:clearSel { [self notImplemented]; }
- (BOOL)colorable { [self notImplemented]; }
- currentColor:cc { [self notImplemented]; }
- deleteCurrentStamp { [self notImplemented]; }
- eyedropper:aButton action:aSel cursor:aCursor { [self notImplemented]; }
- findButton:aSel { [self notImplemented]; }
- getColor { [self notImplemented]; }
- getNib { [self notImplemented]; }
- getSpecial { [self notImplemented]; }
- keep:keepButton with:keepSel { [self notImplemented]; }
- mouseUpBalk:evt { [self notImplemented]; }
- notCurrentlyPainting { [self notImplemented]; }
- pickup:actionButton action:aSel cursor:aCursor { [self notImplemented]; }
- pickupForm:stampForm { [self notImplemented]; }
- scrollStamps:actionButton action:aSel { [self notImplemented]; }
- setAction:aSel { [self notImplemented]; }
- showColor { [self notImplemented]; }
- showColorPalette { [self notImplemented]; }
- showColorPalette:evt { [self notImplemented]; }
- stampCursorBeCursorFor:anAction { [self notImplemented]; }
- stampDeEmphasize { [self notImplemented]; }
- stampForm { [self notImplemented]; }
- stampHolder { [self notImplemented]; }
- stampHolder:newOne { [self notImplemented]; }
- takeColorEvt:evt from:colorpicker { [self notImplemented]; }
- tool { [self notImplemented]; }
- tool:actionButton action:aSel cursor:aCursor { [self notImplemented]; }
- toss:cancelButton with:cancelSel { [self notImplemented]; }
- undo:undoButton with:undoSel { [self notImplemented]; }

@end
 
