
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PaintBoxMorph.h,v 1.2 1999/05/24 20:34:30 stes Exp $
 */

#ifndef __PAINTBOXMORPH_H__

#include <ImageMorph.h>

@interface PaintBoxMorph : ImageMorph
{
	id action;
	id tool;
	id currentCursor;
	id thumbnail;
	id currentColor;
	id currentBrush;
	id colorMemory;
	id colorPatch;
	id stampHolder;
	id rotationTabForm;
	id scaleTabForm;
	id colorMemoryThin;
	id brushes;
}

/* class methods */

+ fixUpPrototype;
+ flushPrototype;
+ new;
+ prototype;
+ releaseTemporaryForms;

/* initialization */

- createButtons;
- init3;
- init4;
- initialize;
- loadColorChooser;
- loadCursors;
- loadOnImage:(STR)filename;
- loadPressedImage:(STR)filename;
- loadRotScalePics;
- loadoffImage:(STR)filename;
- moveButtons;
- noVeneer;

/* other */

- colorMemory;
- colorMemory:aMorph;
- colorPatch;
- copyRecordingIn:dict;
- rotationTabForm;
- scaleTabForm;
- updateReferencesUsing:aDict;

/* actions */

- actionCursor;
- brush:brushButton action:aSel nib:aMask;
- (BOOL)brushable;
- clear:clearButton with:clearSel;
- (BOOL)colorable;
- currentColor:cc;
- deleteCurrentStamp;
- eyedropper:aButton action:aSel cursor:aCursor;
- findButton:aSel;
- getColor;
- getNib;
- getSpecial;
- keep:keepButton with:keepSel;
- mouseUpBalk:evt;
- notCurrentlyPainting;
- pickup:actionButton action:aSel cursor:aCursor;
- pickupForm:stampForm;
- scrollStamps:actionButton action:aSel;
- setAction:aSel;
- showColor;
- showColorPalette;
- showColorPalette:evt;
- stampCursorBeCursorFor:anAction;
- stampDeEmphasize;
- stampForm;
- stampHolder;
- stampHolder:newOne;
- takeColorEvt:evt from:colorpicker;
- tool;
- tool:actionButton action:aSel cursor:aCursor;
- toss:cancelButton with:cancelSel;
- undo:undoButton with:undoSel;

@end
 
#define __PAINTBOXMORPH_H__
#endif

