
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PaintBoxColorPicker.h,v 1.2 1999/05/24 20:19:38 stes Exp $
 */

#ifndef __PAINTBOXCOLORPICKER_H__

#include <ImageMorph.h>

@interface PaintBoxColorPicker : ImageMorph
{
	id currentColor;
	id locOfCurrent;
}

/* initialization */

- initialize;

/* accessing */

- currentColor;
- currentColor:cc;

/* drawing */

- drawOn:aCanvas;
- ringColor;

/* event handling */

- endColorSelection:evt;
- initMouseHandlers;
- selectColor:evt;
- startColorSelection:evt;

@end
 
#define __PAINTBOXCOLORPICKER_H__
#endif

