
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphicEvent.m,v 1.2 1999/05/24 20:05:25 stes Exp $
 */

#include "MorphicEvent.h"

@implementation MorphicEvent

/* class methods */

+ new { [self notImplemented]; }
+ newWorldExtent:aPoint { [self notImplemented]; }
+ readFrom:(STR)filename { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }

/* accessing */

- buttons { [self notImplemented]; }
- hand { [self notImplemented]; }
- type { [self notImplemented]; }

/* classification */

- (BOOL)isKeystroke { [self notImplemented]; }
- (BOOL)isMouse { [self notImplemented]; }
- (BOOL)isMouseDown { [self notImplemented]; }
- (BOOL)isMouseMove { [self notImplemented]; }
- (BOOL)isMouseUp { [self notImplemented]; }

/* equality */

- (BOOL)isEqual:x { [self notImplemented]; }
- (unsigned)hash { [self notImplemented]; }

/* mouse */

- (BOOL)anyButtonPressed { [self notImplemented]; }
- (BOOL)blueButtonPressed { [self notImplemented]; }
- (BOOL)redButtonPressed { [self notImplemented]; }
- (BOOL)yellowButtonPressed { [self notImplemented]; }
- targetPoint { [self notImplemented]; }
- cursorPoint { [self notImplemented]; }
- transformedBy:aMorphicTransform { [self notImplemented]; }

/* keyboard */

- commandKeyPressed { [self notImplemented]; }
- controlKeyPressed { [self notImplemented]; }
- keyCharacter { [self notImplemented]; }
- keyValue { [self notImplemented]; }
- shiftPressed { [self notImplemented]; }

/* printing */

- printOn:(IOD)x { [self notImplemented]; }
- (BOOL)storeOn:(STR)filename { [self notImplemented]; }

/* private */

- setButtons:mask { [self notImplemented]; }
- setCursorPoint:aPoint { [self notImplemented]; }
- setHand:aHandMorph { [self notImplemented]; }
- setKeyValue:keyVal mousePoint:aPoint buttons:mask hand:hand { [self notImplemented]; }
- setMousePoint:aPoint buttons:mask lastEvent:evt hand:hand { [self notImplemented]; }
- setType:type { [self notImplemented]; }
- setType:type cursorPoint:pt buttons:mask keyValue:kv { [self notImplemented]; }

@end

