
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphicEvent.h,v 1.2 1999/05/24 20:05:25 stes Exp $
 */

#ifndef __MORPHICEVENT_H__

#include <Object.h>

@interface MorphicEvent : Object
{
	int type;
	id cursorPoint;
	id buttons;
	id keyValue;
	id sourceHand;
}

/* class methods */

+ new;
+ newWorldExtent:aPoint;
+ readFrom:(STR)filename;

/* initialization */

- initialize;

/* accessing */

- buttons;
- hand;
- type;

/* classification */

- (BOOL)isKeystroke;
- (BOOL)isMouse;
- (BOOL)isMouseDown;
- (BOOL)isMouseMove;
- (BOOL)isMouseUp;

/* equality */

- (BOOL)isEqual:x;
- (unsigned)hash;

/* mouse */

- (BOOL)anyButtonPressed;
- (BOOL)blueButtonPressed;
- (BOOL)redButtonPressed;
- (BOOL)yellowButtonPressed;
- targetPoint;
- cursorPoint;
- transformedBy:aMorphicTransform;

/* keyboard */

- commandKeyPressed;
- controlKeyPressed;
- keyCharacter;
- keyValue;
- shiftPressed;

/* printing */

- printOn:(IOD)x;
- (BOOL)storeOn:(STR)filename;

/* private */

- setButtons:mask;
- setCursorPoint:aPoint;
- setHand:aHandMorph;
- setKeyValue:keyVal mousePoint:aPoint buttons:mask hand:hand;
- setMousePoint:aPoint buttons:mask lastEvent:evt hand:hand;
- setType:type;
- setType:type cursorPoint:pt buttons:mask keyValue:kv;

@end
 
#define __MORPHICEVENT_H__
#endif

