
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: FormCanvas.h,v 1.3 1999/06/06 20:26:03 stes Exp $
 */

#ifndef __FORMCANVAS_H__

#include <Canvas.h>

@interface FormCanvas : Canvas
{
	id form;
	id port;
	id shadowStipple;
}

/* copying */

- copy;

/* accessing */

- (unsigned)depth;
- extent;
- form;

/* drawing */

- fillColor:aColor;
- fillOval:r color:c borderWidth:bw borderColor:bc;
- fillRectangle:r color:c;
- frameAndFillRectangle:r fillColor:fc borderWidth:bw borderColor:bc;
- frameAndFillRectangle:r fillColor:fc borderWidth:bw topLeftColor:tlc bottomRightColor:brc;
- frameRectangle:r width:w color:c;
- image:aForm at:aPoint sourceRect:sourceRect rule:rule;
- imageWithOpaqueWhite:aForm at:aPoint;
- line:pt1 to:pt2 brushForm:brush;
- line:pt1 to:pt2 width:w color:c;
- paragraph:p bounds:b color:c;
- point:p color:c;
- stencil:stencilForm at:aPoint color:aColor;
- text:s bounds:boundsRect font:fontOrNil color:c;

/* other */

- asBalloonCanvas;
- showAt:pt;
- showAt:pt invalidRects:updateRects;
- warpFrom:sourceQuad toRect:destRect;

/* private */

- drawColor:aColor;
- drawRule:aRule color:aColor;
- resetGrafPort;
- setForm:aForm;
- setOrigin:aPoint clipRect:aRectangle;
- setShadowDrawing;
- stipple;
- stipple:newStipple;

@end
 
#define __FORMCANVAS_H__
#endif

