
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: EventRecorderMorph.m,v 1.2 1999/06/06 20:26:03 stes Exp $
 */

#include "Canvas.h"

@implementation Canvas

/* initialization */

- flush { [self notImplemented]; }
- reset { [self notImplemented]; }

/* copying */

- copy { [self notImplemented]; }
- copyClipRect:aRectangle { [self notImplemented]; }
- copyForShadowDrawingOffset:aPoint { [self notImplemented]; }
- copyOffset:aPoint { [self notImplemented]; }
- copyOffset:aPoint clipRect:aRectangle { [self notImplemented]; }
- copyOrigin:aPoint clipRect:aRectangle { [self notImplemented]; }

/* accessing */

- clipRect { [self notImplemented]; }
- (unsigned)depth { [self notImplemented]; }
- extent { [self notImplemented]; }
- form { [self notImplemented]; }
- origin { [self notImplemented]; }

/* testing */

- (BOOL)isBalloonCanvas { [self notImplemented]; }
- (BOOL)isVisible:aRectangle { [self notImplemented]; }

/* drawing */

- fillColor:aColor { [self notImplemented]; }
- fillOval:r color:c { [self notImplemented]; }
- fillOval:r color:c borderWidth:bw borderColor:bc { [self notImplemented]; }
- fillRectangle:r color:c { [self notImplemented]; }
- frameAndFillRectangle:r fillColor:fc borderWidth:bw borderColor:bc { [self notImplemented]; }
- frameAndFillRectangle:r fillColor:fc borderWidth:bw topLeftColor:tlc bottomRightColor:brc { [self notImplemented]; }
- frameOval:r color:c { [self notImplemented]; }
- frameOval:r width:w color:c { [self notImplemented]; }
- frameRectangle:r color:c { [self notImplemented]; }
- frameRectangle:r width:w color:c { [self notImplemented]; }
- image:aForm at:aPoint { [self notImplemented]; }
- image:aForm at:aPoint rule:combinationrule { [self notImplemented]; }
- image:aForm at:aPoint sourceRect:sourceRect rule:rule { [self notImplemented]; }
- imageWithOpaqueWhite:aForm at:aPoint { [self notImplemented]; }
- line:pt1 to:pt2 brushForm:brush { [self notImplemented]; }
- line:pt1 to:pt2 color:c { [self notImplemented]; }
- line:pt1 to:pt2 width:w color:c { [self notImplemented]; }
- paragraph:p bounds:b color:c { [self notImplemented]; }
- point:p color:c { [self notImplemented]; }
- render:anObject { [self notImplemented]; }
- text:s at:pt font:fontOrNil color:c { [self notImplemented]; }
- text:s bounds:boundsRect font:fontOrNil color:c { [self notImplemented]; }

/* private */

- setOrigin:aPoint clipRect:aRectangle { [self notImplemented]; }
- setShadowDrawing { [self notImplemented]; }
- (BOOL)shadowDrawing { [self notImplemented]; }

@end
 
