
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: EventRecorderMorph.h,v 1.1 1999/05/24 19:14:26 stes Exp $
 */

#ifndef __CANVAS_H__

#include <Object.h>

@interface Canvas : Object
{
	id origin;
	id clipRect;
	BOOL shadowDrawing;
}

/* initialization */

- flush;
- reset;

/* copying */

- copy;
- copyClipRect:aRectangle;
- copyForShadowDrawingOffset:aPoint;
- copyOffset:aPoint;
- copyOffset:aPoint clipRect:aRectangle;
- copyOrigin:aPoint clipRect:aRectangle;

/* accessing */

- clipRect;
- depth;
- extent;
- form;
- origin;

/* testing */

- (BOOL)isBalloonCanvas;
- (BOOL)isVisible:aRectangle;

/* drawing */

- fillColor:aColor;
- fillOval:r color:c;
- fillOval:r color:c borderWidth:bw borderColor:bc;
- fillRectangle:r color:c;
- frameAndFillRectangle:r fillColor:fc borderWidth:bw borderColor:bc;
- frameAndFillRectangle:r fillColor:fc borderWidth:bw topLeftColor:tlc bottomRightColor:brc;
- frameOval:r color:c;
- frameOval:r width:w color:c;
- frameRectangle:r color:c;
- frameRectangle:r width:w color:c;
- image:aForm at:aPoint;
- image:aForm at:aPoint rule:combinationrule;
- image:aForm at:aPoint sourceRect:sourceRect rule:rule;
- imageWithOpaqueWhite:aForm at:aPoint;
- line:pt1 to:pt2 brushForm:brush;
- line:pt1 to:pt2 color:c;
- line:pt1 to:pt2 width:w color:c;
- paragraph:p bounds:b color:c;
- point:p color:c;
- render:anObject;
- text:s at:pt font:fontOrNil color:c;
- text:s bounds:boundsRect font:fontOrNil color:c;

/* private */

- setOrigin:aPoint clipRect:aRectangle;
- setShadowDrawing;
- (BOOL)shadowDrawing;

@end
 
#define __CANVAS_H__
#endif

