
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: EventHandler.m,v 1.2 1999/05/25 19:55:43 stes Exp $
 */

#include "EventHandler.h"

@implementation EventHandler

/* initialization */

- adaptToWorld { [self notImplemented]; }
- forgetDispatchesTo:aSelector { [self notImplemented]; }
- on:eventName send:selector to:recipient { [self notImplemented]; }
- on:eventName send:selector to:recipient withValue:value { [self notImplemented]; }

/* testing */

- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- (BOOL)handlsMouseOver:evt { [self notImplemented]; }
- (BOOL)handlesMouseOverDragging:evt { [self notImplemented]; }

/* events */

- keyStroke:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseDown:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseEnter:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseEnterDragging:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseLeave:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseLeaveDragging:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseStillDown:evt fromMorph:sourceMorph { [self notImplemented]; }
- mouseUp:evt fromMorph:sourceMorph { [self notImplemented]; }
- send:selector to:recipient withEvent:evt fromMorph:sourceMorph { [self notImplemented]; }

/* access */

- firstMouseSelector { [self notImplemented]; }
- messageList { [self notImplemented]; }
- mouseDownSelector { [self notImplemented]; }
- mouseUpSelector { [self notImplemented]; }
- printOn:(IOD)iod { [self notImplemented]; }

@end
 
