
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: EventHandler.h,v 1.2 1999/05/25 19:55:43 stes Exp $
 */

#ifndef __EVENTHANDLER_H__

#include <Object.h>

@interface EventHandler : Object
{
	id mouseDownRecipient;
	id mouseStillDownRecipient;
	id mouseUpRecipient;
	id mouseEnterRecipient;
	id mouseLeaveRecipient;
	id mouseEnterDraggingRecipient;
	id mouseLeaveDraggingRecipient;
	id keyStrokeRecipient;
	id valueParameter;
}

/* initialization */

- adaptToWorld;
- forgetDispatchesTo:aSelector;
- on:eventName send:selector to:recipient;
- on:eventName send:selector to:recipient withValue:value;

/* testing */

- (BOOL)handlesMouseDown:evt;
- (BOOL)handlsMouseOver:evt;
- (BOOL)handlesMouseOverDragging:evt;

/* events */

- keyStroke:evt fromMorph:sourceMorph;
- mouseDown:evt fromMorph:sourceMorph;
- mouseEnter:evt fromMorph:sourceMorph;
- mouseEnterDragging:evt fromMorph:sourceMorph;
- mouseLeave:evt fromMorph:sourceMorph;
- mouseLeaveDragging:evt fromMorph:sourceMorph;
- mouseStillDown:evt fromMorph:sourceMorph;
- mouseUp:evt fromMorph:sourceMorph;
- send:selector to:recipient withEvent:evt fromMorph:sourceMorph;

/* access */

- firstMouseSelector;
- messageList;
- mouseDownSelector;
- mouseUpSelector;
- printOn:(IOD)iod;

@end
 
#define __EVENTHANDLER_H__
#endif

