
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: DamageRecorder.m,v 1.3 1999/06/02 18:30:49 stes Exp $
 */

#include "DamageRecorder.h"
#include <ordcltn.h>
#include <assert.h>

@implementation DamageRecorder

/* class methods */

+ new
{
  return [[super new] reset];
}

/* instance methods */

- doFullRepaint
{
  totalRepaint++;
  return self;
}

- invalidRectsFullBounds:aRect
{
  if (totalRepaint) {
    return [OrderedCollection with:1,aRect];
  } else {
    return [invalidRects copy];
  }
}

- recordInvalidRect:aRect
{
  if (totalRepaint) {
    return self;
  } else {
    assert([invalidRects isKindOf:OrderedCollection]);
    if ([invalidRects size] == 10) {
      [self doFullRepaint];
    } else {
      // simplified version ...
      [invalidRects add:aRect];
    }
    return self;
  }
}
 
- reset
{
  invalidRects = [OrderedCollection new];
  totalRepaint = NO;
  return self;
}

- (BOOL)updateIsNeeded
{
  return totalRepaint || [invalidRects size] > 0;
}

@end
 
