
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Project.m,v 1.1 1999/06/01 22:08:00 stes Exp $
 */

#include "Project.h"
#include <WorldMorph.h>
#include <Color.h>
#include <ordcltn.h>

@implementation Project

/* class initialization */

+ initialize
{
  if (CurrentProject == nil) {
    CurrentProject = [[super new] initialProject];
  }
  return self;
}

/* instance creation */

+ new
{
  return [self newMorphic];
}

+ newMorphic
{
  return [[super new] initFromParent:CurrentProject];
}

+ newMorphicConstruction
{
  id newproj = [self newMorphic];
  [[newproj world] configureForConstruction];
  return newproj;
}

/* utilities */

+ returnToPreviousProject
{
  id prevproj = [CurrentProject previousProject];
  if (prevproj) [prevproj enter:YES];
  return self;
}

/* constants */

+ current
{
  return CurrentProject;
}

/* initialization */

- initialExtent
{
  return nil;
}

- initialProject
{
  [self saveState];
  [self setParent:self];
  return self;
}

- defaultBackgroundColor
{
  return [Color lightOrange];
}

- initFromParent:aProject
{
  world = [WorldMorph new];
  parentProject = aProject;
  return self;
}

/* accessing */

- (BOOL)isMorphic
{
  return YES;
}

- (BOOL)isTopProject
{
  return YES;
}

- labelString
{
  return nil;
}

- leaveThisWorld
{
  exitFlag++;
  return self;
}

- nextProject
{
  return nextProject;
}

- parent
{
  return parentProject;
}

- previousProject
{
  return previousProject;
}

- setParent:anObject
{
  parentProject = anObject;
  nextProject = previousProject = nil;
  return self;
}

- setThumbnail:aForm
{
  thumbnail = aForm;
  return self;
}

- thumbnail
{
  return thumbnail;
}

- world
{
  return world;
}

/* menu messages */

- enter:(BOOL)returningflag
{
  if (self == CurrentProject) return self;
  
  if (returningflag) {
    nextProject = CurrentProject;
  } else {
    previousProject = CurrentProject;
  } 
  
  [CurrentProject makeThumbnail];
  [CurrentProject saveState];

  CurrentProject = self;
  
  if ([world isMorph]) {
    World = world;
    [world install];
  } else {
    [self notImplemented];
  }
  
  return self;
}

- exit
{
  if ([self isTopProject]) {
    [self error:"can't exit top project"];
  } else {
    [parentProject enter:NO];
  }
  return self;
}

- makeThumbnail
{
  return self;
}

- saveState
{
  return self;
}

@end
 
