
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Project.h,v 1.1 1999/06/01 22:08:00 stes Exp $
 */

#ifndef __PROJECT_H__

#include <Object.h>

@interface Project : Object
{
  id world;
  id nextProject;
  id parentProject;
  id previousProject;
  id displayDepth;
  id guards;
  id thumbnail;
  BOOL exitFlag;
} : {
  id CurrentProject;
}

/* class initialization */

+ initialize;

/* instance creation */

+ new;
+ newMorphic;
+ newMorphicConstruction;

/* utilities */

+ returnToPreviousProject;

/* constants */

+ current;

/* initialization */

- initialExtent;
- initialProject;
- defaultBackgroundColor;
- initFromParent:aProject;

/* accessing */

- (BOOL)isMorphic;
- (BOOL)isTopProject;
- labelString;
- leaveThisWorld;
- nextProject;
- parent;
- previousProject;
- setParent:anObject;
- setThumbnail:aForm;
- thumbnail;
- world;

/* menu messages */

- enter:(BOOL)returningflag;
- exit;
- makeThumbnail;
- saveState;

@end
 
#define __PROJECT_H__
#endif

