
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Model.m,v 1.1 1999/06/01 22:08:00 stes Exp $
 */

#include "Model.h"
#include <ordcltn.h>

@implementation Model

/* dependents */

- addDependent:anObject
{
  if (!dependents) dependents = [OrderedCollection new];
  [dependents addIfAbsent:anObject];
  return self;
}

- breakDependents
{
  dependents = nil;
  return self;
}

- (BOOL)canDiscardEdits
{
  if (dependents) {
    int i,n;
    for(i=0,n=[dependents size];i<n;i++) {
      if (![[dependents at:i] canDiscardEdits]) return NO;
    }
    return YES;
  } else {
    return YES;
  }
}

- dependents
{
  return dependents;
}

- (BOOL)hasUnacceptedEdits
{
  if (dependents) {
    int i,n;
    for(i=0,n=[dependents size];i<n;i++) {
      if ([[dependents at:i] hasUnacceptedEdits]) return YES;
    }
    return NO;
  } else {
    return NO;
  }
}

- removeDependent:anObject
{
  if (dependents) [dependents remove:anObject];
  return self;
}

@end
 
