
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MenuMorph.m,v 1.3 1999/05/29 15:27:05 stes Exp $
 */

#include "MenuMorph.h"

@implementation MenuMorph

/* example */

+ example { [self notImplemented]; }

/* instance creation */

+ entitled:aString { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }
- setDefaultParameters { [self notImplemented]; }
- setTitleParametersFor:aMenuTitle { [self notImplemented]; }

/* accessing */

- (BOOL)hasSubMenu:aMenuMorph { [self notImplemented]; }
- items { [self notImplemented]; }
- lastSelection { [self notImplemented]; }
- lastSelection:aString { [self notImplemented]; }
- popUpOwner { [self notImplemented]; }
- popUpOwner:aMenuItemMorph { [self notImplemented]; }
- (BOOL)stayUp { [self notImplemented]; }
- stayUp:(BOOL)aBoolean { [self notImplemented]; }

/* construction */

- add:aString action:(SEL)aSel { [self notImplemented]; }
- add:aString selector:(SEL)aSel argument:arg { [self notImplemented]; }
- add:aString subMenu:aMenuMorph { [self notImplemented]; }
- add:aString target:anObject action:(SEL)aSel { [self notImplemented]; }
- add:aString target:anObject selector:(SEL)aSel { [self notImplemented]; }
- add:aString target:anObject selector:(SEL)aSel argument:arg { [self notImplemented]; }
- add:aString target:anObject selector:(SEL)aSel argumentList:argList { [self notImplemented]; }
- addLine { [self notImplemented]; }
- addList:listOfPairs { [self notImplemented]; }
- addStayUpItem { [self notImplemented]; }
- addTitle:aString { [self notImplemented]; }
- balloonTextForLastItem:balloonText { [self notImplemented]; }
- defaultTarget:anObject { [self notImplemented]; }
- labels:labelList lines:linesArray selections:selectionsArray { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }
- addItem { [self notImplemented]; }
- addTitle { [self notImplemented]; }
- (BOOL)canDetachSubMenu:hand { [self notImplemented]; }
- detachSubMenu:evt { [self notImplemented]; }
- removeItem:evt { [self notImplemented]; }
- setInvokingView:invokingView { [self notImplemented]; }
- setTarget:evt { [self notImplemented]; }
- toggleStayUp:evt { [self notImplemented]; }

/* layout */

- (int)minHeightWhenEmpty { [self notImplemented]; }
- (int)minWidthWhenEmpty { [self notImplemented]; }

/* control */

- deleteIfPopUp { [self notImplemented]; }
- invokeItem:aMenuItem { [self notImplemented]; }
- invokeItem:aMenuItem event:evt { [self notImplemented]; }
- popUpAdjacentTo:rightOrLeftPoint forHand:hand from:sourceItem { [self notImplemented]; }
- popUpAt:aPoint event:evt { [self notImplemented]; }
- popUpAt:aPoint forHand:hand { [self notImplemented]; }
- popUpAt:aPoint forHand:hand from:sourceItem { [self notImplemented]; }

/* copying */

- veryDeepFixupWith:deepCopier { [self notImplemented]; }
- veryDeepInner:deepCopier { [self notImplemented]; }

@end
 
