
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MenuMorph.h,v 1.3 1999/05/29 15:27:05 stes Exp $
 */

#ifndef __MENUMORPH_H__

#include <AlignmentMorph.h>

@interface MenuMorph : AlignmentMorph
{
	BOOL stayUp;
	id defaultTarget;
	id lastSelection;
	id originalEvent;
	id popUpOwner;
}

/* example */

+ example;

/* instance creation */

+ entitled:aString;

/* initialization */

- initialize;
- setDefaultParameters;
- setTitleParametersFor:aMenuTitle;

/* accessing */

- (BOOL)hasSubMenu:aMenuMorph;
- items;
- lastSelection;
- lastSelection:aString;
- popUpOwner;
- popUpOwner:aMenuItemMorph;
- (BOOL)stayUp;
- stayUp:(BOOL)aBoolean;

/* construction */

- add:aString action:(SEL)aSel;
- add:aString selector:(SEL)aSel argument:arg;
- add:aString subMenu:aMenuMorph;
- add:aString target:anObject action:(SEL)aSel;
- add:aString target:anObject selector:(SEL)aSel;
- add:aString target:anObject selector:(SEL)aSel argument:arg;
- add:aString target:anObject selector:(SEL)aSel argumentList:argList;
- addLine;
- addList:listOfPairs;
- addStayUpItem;
- addTitle:aString;
- balloonTextForLastItem:balloonText;
- defaultTarget:anObject;
- labels:labelList lines:linesArray selections:selectionsArray;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- addItem;
- addTitle;
- (BOOL)canDetachSubMenu:hand;
- detachSubMenu:evt;
- removeItem:evt;
- setInvokingView:invokingView;
- setTarget:evt;
- toggleStayUp:evt;

/* layout */

- (int)minHeightWhenEmpty;
- (int)minWidthWhenEmpty;

/* control */

- deleteIfPopUp;
- invokeItem:aMenuItem;
- invokeItem:aMenuItem event:evt;
- popUpAdjacentTo:rightOrLeftPoint forHand:hand from:sourceItem;
- popUpAt:aPoint event:evt;
- popUpAt:aPoint forHand:hand;
- popUpAt:aPoint forHand:hand from:sourceItem;

/* copying */

- veryDeepFixupWith:deepCopier;
- veryDeepInner:deepCopier;

@end
 
#define __MENUMORPH_H__
#endif

