
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MenuItemMorph.m,v 1.3 1999/05/29 13:47:30 stes Exp $
 */

#include "MenuItemMorph.h"

@implementation MenuItemMorph

/* class methods */

+ initialize { }

/* initialization */

- initialize { [self notImplemented]; }

/* accessing */

- adaptToWorld:aWorld { [self notImplemented]; }
- arguments { [self notImplemented]; }
- arguments:aCollection { [self notImplemented]; }
- (BOOL)isEnabled { [self notImplemented]; }
- isEnabled:(BOOL)aBoolean { [self notImplemented]; }
- (SEL)selector { [self notImplemented]; }
- selector:(SEL)aSel { [self notImplemented]; }
- subMenu { [self notImplemented]; }
- subMenu:aMenuMorph { [self notImplemented]; }
- target { [self notImplemented]; }
- target:aTarget { [self notImplemented]; }

/* drawing */

- drawOn:aCanvas { [self notImplemented]; }

/* events */

- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- mouseDown:evt { [self notImplemented]; }
- mouseMove:evt { [self notImplemented]; }
- mouseUp:evt { [self notImplemented]; }

/* layout */

- hResizing { [self notImplemented]; }
- (BOOL)isAlignmentMorph { [self notImplemented]; }
- layoutInWidth:w height:h { [self notImplemented]; }
- minHeight { [self notImplemented]; }
- minWidth { [self notImplemented]; }
- vResizing { [self notImplemented]; }

/* private */

- bringMenuChainToFront { [self notImplemented]; }
- deletePopupBackToCommonMenuWith { [self notImplemented]; }
- deselectForNewMorph { [self notImplemented]; }
- deselectItem { [self notImplemented]; }
- hideSubmenu { [self notImplemented]; }
- (BOOL)isInMenu { [self notImplemented]; }
- isSelected:(BOOL)aBoolean { [self notImplemented]; }
- selectFromHand:aHand { [self notImplemented]; }

/* copying */

- veryDeepFixupWith:deepCopier { [self notImplemented]; }
- veryDeepInner:deepCopier { [self notImplemented]; }

@end
 
