
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MenuItemMorph.h,v 1.2 1999/05/26 19:36:01 stes Exp $
 */

#ifndef __MENUITEMMORPH_H__

#include <StringMorph.h>

@interface MenuItemMorph : StringMorph
{
	BOOL isInTransition;
	BOOL isEnabled;
	BOOL isSelected;
	id subMenu;
	id target;
	SEL selector;
	id arguments;
}

/* class methods */

+ initialize;

/* initialization */

- initialize;

/* accessing */

- adaptToWorld:aWorld;
- arguments;
- arguments:aCollection;
- (BOOL)isEnabled;
- isEnabled:(BOOL)aBoolean;
- (SEL)selector;
- selector:(SEL)aSel;
- subMenu;
- subMenu:aMenuMorph;
- target;
- target:aTarget;

/* drawing */

- drawOn:aCanvas;

/* events */

- (BOOL)handlesMouseDown:evt;
- mouseDown:evt;
- mouseMove:evt;
- mouseUp:evt;

/* layout */

- hResizing;
- (BOOL)isAlignmentMorph;
- layoutInWidth:w height:h;
- minHeight;
- minWidth;
- vResizing;

/* private */

- bringMenuChainToFront;
- deletePopupBackToCommonMenuWith;
- deselectForNewMorph;
- deselectItem;
- hideSubmenu;
- (BOOL)isInMenu;
- isSelected:(BOOL)aBoolean;
- selectFromHand:aHand;

/* copying */

- veryDeepFixupWith:deepCopier;
- veryDeepInner:deepCopier;

@end
 
#define __MENUITEMMORPH_H__
#endif

