
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: WorldMorph.m,v 1.7 1999/06/01 22:07:58 stes Exp $
 */

#include "WorldMorph.h"
#include <DamageRecorder.h>
#include <Color.h>
#include <HandMorph.h>
#include <objpak.h>

id World;

@implementation WorldMorph

/* class methods */

+ defaultNameStemForInstances { [self notImplemented]; }

+ disableDeferredUpdates:(BOOL)aBoolean { [self notImplemented]; }

+ (BOOL)includeInNewMorphMenu
{
  return NO;
}

// set amount of time (milli seconds) that may transpire between two
// calls to -doOneCycle

+ MinCycleLapse:(int)millisecs
{
  MinCycleLapse = millisecs;
  return self;
}

+ initialize
{
  [self MinCycleLapse:20];
  return self;
}

+ openWithStandardPartsBinShowing { [self notImplemented]; }
+ startUp { [self notImplemented]; }

/* initialization */

- configureForConstruction { [self notImplemented]; }

- initialize
{
  [super initialize];
  color = [Color r:0.937 g:0.937 b:0.937];
  fillColor2 = color;
  hands = [OrderedCollection new];
  [self addHand:[HandMorph new]];
  viewBox = canvas = nil;
  damageRecorder = [DamageRecorder new];
  stepList = [OrderedCollection new];
  lastStepTime = 0;
  model = nil;
  return self;
}

- open { [self notImplemented]; }
- openWithTitle:aString { [self notImplemented]; }
- openWithTitle:aString cautionOnClose:(BOOL)aBoolean { [self notImplemented]; }
- restoreDisplay { [self notImplemented]; }
- restoreFlapsDisplay { [self notImplemented]; }

/* install / exit */

- exit { [self notImplemented]; }
- goBack { [self notImplemented]; }
- install { [self notImplemented]; }
- installFlaps { [self notImplemented]; }
- pauseEventRecorder { [self notImplemented]; }
- sleep { [self notImplemented]; }

/* classification */

- (BOOL)isWorldMorph { [self notImplemented]; }

/* accessing */

- activeHand { [self notImplemented]; }
- canvas { [self notImplemented]; }
- canvas:aCanvas { [self notImplemented]; }
- color:aColor { [self notImplemented]; }
- viewBox { [self notImplemented]; }
- viewBox:aRectangle { [self notImplemented]; }
- world { [self notImplemented]; }

/* submorphs - accessing */

- allMorphsDo:aBlock { [self notImplemented]; }
- allNonFlapRelatedSubmorphs { [self notImplemented]; }

/* drawing */

- assuredCanvas { [self notImplemented]; }
- displayWorld { [self notImplemented]; }
- displayWorldAsTwoTone { [self notImplemented]; }
- displayWorldNonIncrementally { [self notImplemented]; }
- displayWorldSafely { [self notImplemented]; }
- doDeferredUpdating { [self notImplemented]; }
- drawInvalidAreasOn:aCanvas { [self notImplemented]; }
- flashRects:rectangleList color:aColor { [self notImplemented]; }
- handleFatalDrawingError:errMsg { [self notImplemented]; }
- selectHandsToDrawForDamage:damageList { [self notImplemented]; }

/* events */

- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- mouseDown:evt { [self notImplemented]; }

/* stepping */

- adjustWakeupTimes { [self notImplemented]; }
- adjustWakeupTImesIfNeeded { [self notImplemented]; }
- (BOOL)isStepping:aMorph { [self notImplemented]; }
- runStepMethods { [self notImplemented]; }
- startStepping:aMorph { [self notImplemented]; }
- startSteppingSubmorphsOf:aMorph { [self notImplemented]; }

- stopStepping:aMorph
{
  int i,n;
  for(i=0,n=[stepList size];i<n;i++) {
  }
  return self;
}

/* hands */

- activeHand:aHandMorph { [self notImplemented]; }
- addHand:aHandMorph { [self notImplemented]; }
- hands { [self notImplemented]; }
- removeHand:aHandMorph { [self notImplemented]; }

/* change reporting */

- fullRepaintNeeded { [self notImplemented]; }
- invalidRect:damageRect { [self notImplemented]; }

/* interaction loop */

- doOneCycle { [self notImplemented]; }
- doOneCycleInBackground { [self notImplemented]; }
- doOneCycleNow { [self notImplemented]; }
- doOneSubCycle { [self notImplemented]; }
- interCyclePause:millisecs { [self notImplemented]; }
- startBackgroundProcess { [self notImplemented]; }

/* dropping */

- acceptDroppingMorph:aMorph event:evt { [self notImplemented]; }

/* painting support */

- installForm:aForm { [self notImplemented]; }
- paintArea { [self notImplemented]; }
- paintAreaFor:aSketchMorph { [self notImplemented]; }
- paintBox { [self notImplemented]; }

/* sensing */

- colorAt:aPoint belowMorph:aMorph { [self notImplemented]; }
- patchAt:patchRect without:stopMorph andNothingAbove:stopThere { [self notImplemented]; }

/* halos */

- abandonAllHalos { [self notImplemented]; }
- haloMorphOrNil { [self notImplemented]; }
- haloMorphs { [self notImplemented]; }

/* Etoy support */

- allKnownNames { [self notImplemented]; }
- chooseClickTarget { [self notImplemented]; }
- goVGA { [self notImplemented]; }
- nextPage { [self notImplemented]; }
- presenter { [self notImplemented]; }
- previousPage { [self notImplemented]; }
- referencePlayfield { [self notImplemented]; }
- (BOOL)residesInPartsBin { [self notImplemented]; }
- slotNamesAndTypesForBank:anumber { [self notImplemented]; }
- specialNameInModelFor:aMorph { [self notImplemented]; }
- standardPlayerHit { [self notImplemented]; }
- standardSystemController { [self notImplemented]; }

/* submorphs add/remove */

- addAllMorphs:array { [self notImplemented]; }
- addMorph:aMorph centeredNear:aPoint { [self notImplemented]; }

@end
 
