
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: WorldMorph.h,v 1.5 1999/06/01 22:07:58 stes Exp $
 */

#ifndef __WORLDMORPH_H__

#include <PasteUpMorph.h>

extern id World;

@interface WorldMorph : PasteUpMorph
{
	id hands;
	id activeHand;
	id viewBox;
	id canvas;
	id damageRecorder;
	id stepList;
	id lastStepTime;
	id lastCycleTime;
} : {
  	BOOL DisableDeferredUpdates;
	int MinCycleLapse;
}

/* class methods */

+ defaultNameStemForInstances;
+ disableDeferredUpdates:(BOOL)aBoolean;
+ (BOOL)includeInNewMorphMenu;
+ initialize;
+ openWithStandardPartsBinShowing;
+ startUp;

/* initialization */

- configureForConstruction;
- initialize;
- open;
- openWithTitle:aString;
- openWithTitle:aString cautionOnClose:(BOOL)aBoolean;
- restoreDisplay;
- restoreFlapsDisplay;

/* install / exit */

- exit;
- goBack;
- install;
- installFlaps;
- pauseEventRecorder;
- sleep;

/* classification */

- (BOOL)isWorldMorph;

/* accessing */

- activeHand;
- canvas;
- canvas:aCanvas;
- color:aColor;
- viewBox;
- viewBox:aRectangle;
- world;

/* submorphs - accessing */

- allMorphsDo:aBlock;
- allNonFlapRelatedSubmorphs;

/* drawing */

- assuredCanvas;
- displayWorld;
- displayWorldAsTwoTone;
- displayWorldNonIncrementally;
- displayWorldSafely;
- doDeferredUpdating;
- drawInvalidAreasOn:aCanvas;
- flashRects:rectangleList color:aColor;
- handleFatalDrawingError:errMsg;
- selectHandsToDrawForDamage:damageList;

/* events */

- (BOOL)handlesMouseDown:evt;
- mouseDown:evt;

/* stepping */

- adjustWakeupTimes;
- adjustWakeupTImesIfNeeded;
- (BOOL)isStepping:aMorph;
- runStepMethods;
- startStepping:aMorph;
- startSteppingSubmorphsOf:aMorph;
- stopStepping:aMorph;

/* hands */

- activeHand:aHandMorph;
- addHand:aHandMorph;
- hands;
- removeHand:aHandMorph;

/* change reporting */

- fullRepaintNeeded;
- invalidRect:damageRect;

/* interaction loop */

- doOneCycle;
- doOneCycleInBackground;
- doOneCycleNow;
- doOneSubCycle;
- interCyclePause:millisecs;
- startBackgroundProcess;

/* dropping */

- acceptDroppingMorph:aMorph event:evt;

/* painting support */

- installForm:aForm;
- paintArea;
- paintAreaFor:aSketchMorph;
- paintBox;

/* sensing */

- colorAt:aPoint belowMorph:aMorph;
- patchAt:patchRect without:stopMorph andNothingAbove:stopThere;

/* halos */

- abandonAllHalos;
- haloMorphOrNil;
- haloMorphs;

/* Etoy support */

- allKnownNames;
- chooseClickTarget;
- goVGA;
- nextPage;
- presenter;
- previousPage;
- referencePlayfield;
- (BOOL)residesInPartsBin;
- slotNamesAndTypesForBank:anumber;
- specialNameInModelFor:aMorph;
- standardPlayerHit;
- standardSystemController;

/* submorphs add/remove */

- addAllMorphs:array;
- addMorph:aMorph centeredNear:aPoint;

@end
 
#define __WORLDMORPH_H__
#endif

