
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PasteUpMorph.m,v 1.3 1999/05/26 18:05:32 stes Exp $
 */

#include "PasteUpMorph.h"

@implementation PasteUpMorph

/* class methods */

+ authoringPrototype { [self notImplemented]; }
+ defaultNameStemForInstances { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }

/* cursor */

- cursor { [self notImplemented]; }
- cursor:anumber { [self notImplemented]; }
- cursorAtEnd { [self notImplemented]; }
- rectifyCursor { [self notImplemented]; }
- selectedRect { [self notImplemented]; }
- valueAtCursor { [self notImplemented]; }
- valueAtCursor:aMorph { [self notImplemented]; }

/* display */

- canvasForSubmorphs:canvasForMe { [self notImplemented]; }
- drawOn:aCanvas { [self notImplemented]; }
- (BOOL)padding { [self notImplemented]; }

/* dropping & grabbing */

- acceptDroppingMorph:aMorph event:evt { [self notImplemented]; }
- (BOOL)allowSubmorphExtraction { [self notImplemented]; }
- automaticPhraseExpansion { [self notImplemented]; }
- automaticViewing { [self notImplemented]; }
- morphToDropFrom:aMorph { [self notImplemented]; }
- positionNear:aPoint forExtent:anExtent adjustmentSuggestion:adjPoint { [self notImplemented]; }
- (BOOL)repelsMorph:aMorph event:evt { [self notImplemented]; }
- rootForGrabOf:aMorph { [self notImplemented]; }
- rootMorphsAt:aPoint { [self notImplemented]; }
- (BOOL)wantsDroppedMorph:aMorph event:evt { [self notImplemented]; }

/* layout */

- addCenteredAtBottom:aMorph offset:anOffset { [self notImplemented]; }
- fixLayout { [self notImplemented]; }
- insertionIndexFor:aMorph { [self notImplemented]; }
- laySubpartsOutInOneRow { [self notImplemented]; }
- layoutChanged { [self notImplemented]; }
- layoutRow:mList lastRowBase:lastRowBase { [self notImplemented]; }
- rowBaseFor:mList lastRowBase:lastRowBase { [self notImplemented]; }
- rowMorphsStartingAt:startIndex { [self notImplemented]; }

/* menu & halo */

- addCustomMenuItems:menu hand:aHandMorph { [self notImplemented]; }
- addOptionalHandlesTo:aHalo box:box { [self notImplemented]; }
- addPenMenuItems:menu hand:aHandMorph { [self notImplemented]; }
- addPlayfieldMenuItems:menu hand:aHandMorph { [self notImplemented]; }
- addStackMenuItems:menu hand:aHandMorph { [self notImplemented]; }
- debuggingMenuFor:aHandMorph { [self notImplemented]; }
- (BOOL)wantsHaloFor:aSubmorph { [self notImplemented]; }

/* model */

- createCustomModel { [self notImplemented]; }
- model { [self notImplemented]; }
- modelOrNil { [self notImplemented]; }
- setModel:aModelMorph { [self notImplemented]; }

/* options */

- (BOOL)autoLineLayout { [self notImplemented]; }
- autoLineLayout:(BOOL)aBoolean { [self notImplemented]; }
- automaticViewing:(BOOL)aBoolean { [self notImplemented]; }
- behaveLikeHolder { [self notImplemented]; }
- (BOOL)indicateCursor { [self notImplemented]; }
- indicateCursor:(BOOL)aBoolean { [self notImplemented]; }
- (BOOL)isPartsBin { [self notImplemented]; }
- isPartsBin:(BOOL)aBoolean { [self notImplemented]; }
- (BOOL)openToDragNDrop { [self notImplemented]; }
- openToDragNDrop:(BOOL)aBoolean { [self notImplemented]; }
- replaceTallSubmorphsByThumbnails { [self notImplemented]; }
- (BOOL)resizeToFit { [self notImplemented]; }
- resizeToFit:(BOOL)aBoolean { [self notImplemented]; }
- setPartsBinStatusTo:(BOOL)aBoolean { [self notImplemented]; }
- setThumbnailHeight { [self notImplemented]; }
- toggleAlwaysShowThumbnail { [self notImplemented]; }
- toggleAutoLineLayout { [self notImplemented]; }
- toggleAutomaticPhraseExpansion { [self notImplemented]; }
- toggleAutomaticViewing { [self notImplemented]; }
- toggleIndicateCursor { [self notImplemented]; }
- toggleIsPartsBin { [self notImplemented]; }
- toggleMouseOverHalos { [self notImplemented]; }
- toggleResizeToFit { [self notImplemented]; }
- updateSubmorphThumbnails { [self notImplemented]; }
- (BOOL)wantsMouseOverHalos { [self notImplemented]; }
- wantsMouseOverHalos:(BOOL)aBoolean { [self notImplemented]; }

/* painting */

- backgroundSketch { [self notImplemented]; }
- backgroundSketch:aSketchMorphOrNil { [self notImplemented]; }
- makeNewDrawingWithin { [self notImplemented]; }
- paintBackground { [self notImplemented]; }
- paintingBoundsAround:aPoint { [self notImplemented]; }
- reasonablePaintingExtent { [self notImplemented]; }

/* pen */

- clearTurtleTrails { [self notImplemented]; }
- createOrResizeTrailsForm { [self notImplemented]; }
- drawPenTrailFor:aMorph from:oldPoint to:newPoint { [self notImplemented]; }
- liftAllPens { [self notImplemented]; }
- lowerAllPens { [self notImplemented]; }
- trailMorph { [self notImplemented]; }

/* scripting */

- allTileScriptingElements { [self notImplemented]; }
- emptyAnonymousScriptorFrom:aPlaceHoldingMorph { [self notImplemented]; }
- emptyPermanentScriptorFrom:aPlaceHoldingMorph { [self notImplemented]; }
- expandPhrasesToScripts { [self notImplemented]; }
- scriptorForTextualScript:aSelector ofPlayer:aPlayer { [self notImplemented]; }

/* stack & card */

- becomeStack { [self notImplemented]; }
- doWrap { [self notImplemented]; }
- goToNextCard { [self notImplemented]; }
- goToPreviousCard { [self notImplemented]; }
- installAsCurrent:anInstance { [self notImplemented]; }
- (BOOL)isStackLike { [self notImplemented]; }
- morphsForInstanceData { [self notImplemented]; }
- newCard { [self notImplemented]; }
- scriptPerformer { [self notImplemented]; }

/* misc */

- abandonCostumeHistory { [self notImplemented]; }
- allScriptEditors { [self notImplemented]; }
- alwaysShowThumbnail { [self notImplemented]; }
- cachedOrNewThumbnail { [self notImplemented]; }
- color:aColor { [self notImplemented]; }
- (BOOL)demandsBoolean { [self notImplemented]; }
- fullBounds { [self notImplemented]; }
- heightForThumbnails { [self notImplemented]; }
- impartPrivatePresenter { [self notImplemented]; }
- innocuousName { [self notImplemented]; }
- invalidRect:aRect { [self notImplemented]; }
- (BOOL)isPlayfieldLike { [self notImplemented]; }
- makeDetachable { [self notImplemented]; }
- maxHeightToAvoidThumbnailing { [self notImplemented]; }
- maximumThumbnailWidth { [self notImplemented]; }
- mouseX { [self notImplemented]; }
- mouseY { [self notImplemented]; }
- navigateTo { [self notImplemented]; }
- padding:(int)anumber { [self notImplemented]; }
- prepareToBeSaved { [self notImplemented]; }
- presenter { [self notImplemented]; }
- presenter:aPresenter { [self notImplemented]; }
- replaceSubmorph:oldMorph by:newMorph { [self notImplemented]; }
- (BOOL)residesInPartsBin { [self notImplemented]; }
- roundUpStrays { [self notImplemented]; }
- slotNamesAndTypesForBank:aBank { [self notImplemented]; }
- smallThumbnailForPageSorter { [self notImplemented]; }
- startRunningAll { [self notImplemented]; }
- stepAll { [self notImplemented]; }
- stopRunningAll { [self notImplemented]; }
- thumbnailForPageSorter { [self notImplemented]; }
- unhideHiddenObjects { [self notImplemented]; }
- updateStatusForAllScriptEditors { [self notImplemented]; }
- (BOOL)wantsKeyboardFocusFor:aSubmorph { [self notImplemented]; }

/* flaps */

- accommodateFlap:aFlapTab { [self notImplemented]; }
- addGlobalFlaps { [self notImplemented]; }
- assureFlapTabsFitOnScreen { [self notImplemented]; }
- bringFlapTabsToFront { [self notImplemented]; }
- deleteAllFlapArtifacts { [self notImplemented]; }
- deleteGlobalFlapArtifacts { [self notImplemented]; }
- localFlapTabs { [self notImplemented]; }
- offsetForAccommodating:anExtent onEdge:edgeSymbol { [self notImplemented]; }
- removeAccommodationForFlap:aFlapTab { [self notImplemented]; }

@end

