
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PasteUpMorph.h,v 1.4 1999/06/01 22:07:58 stes Exp $
 */

#ifndef __PASTEUPMORPH_H__

#include <GradientFillMorph.h>

@interface PasteUpMorph : GradientFillMorph
{
  id presenter;
  id model;
  id cursor;
  id padding;
  id backgroundMorph;
  id turtleTrailsForm;
  id turtlePen;
  id lastTurtlePositions;
  BOOL openToDragNDrop;
  BOOL isPartsBin;
  BOOL autoLineLayout;
  BOOL indicateCursor;
  BOOL resizeToFit;
  id fileName;
  BOOL isStackLike;
  id dataInstances;
  id currentDataInstance;
  id userFrameRectangle;
  BOOL wantsMouseOverHalos;
}

/* class methods */

+ authoringPrototype;
+ defaultNameStemForInstances;

/* initialization */

- initialize;

/* cursor */

- cursor;
- cursor:anumber;
- cursorAtEnd;
- rectifyCursor;
- selectedRect;
- valueAtCursor;
- valueAtCursor:aMorph;

/* display */

- canvasForSubmorphs:canvasForMe;
- drawOn:aCanvas;
- (BOOL)padding;

/* dropping & grabbing */

- acceptDroppingMorph:aMorph event:evt;
- (BOOL)allowSubmorphExtraction;
- automaticPhraseExpansion;
- automaticViewing;
- morphToDropFrom:aMorph;
- positionNear:aPoint forExtent:anExtent adjustmentSuggestion:adjPoint;
- (BOOL)repelsMorph:aMorph event:evt;
- rootForGrabOf:aMorph;
- rootMorphsAt:aPoint;
- (BOOL)wantsDroppedMorph:aMorph event:evt;

/* layout */

- addCenteredAtBottom:aMorph offset:anOffset;
- fixLayout;
- insertionIndexFor:aMorph;
- laySubpartsOutInOneRow;
- layoutChanged;
- layoutRow:mList lastRowBase:lastRowBase;
- rowBaseFor:mList lastRowBase:lastRowBase;
- rowMorphsStartingAt:startIndex;

/* menu & halo */

- addCustomMenuItems:menu hand:aHandMorph;
- addOptionalHandlesTo:aHalo box:box;
- addPenMenuItems:menu hand:aHandMorph;
- addPlayfieldMenuItems:menu hand:aHandMorph;
- addStackMenuItems:menu hand:aHandMorph;
- debuggingMenuFor:aHandMorph;
- (BOOL)wantsHaloFor:aSubmorph;

/* model */

- createCustomModel;
- model;
- modelOrNil;
- setModel:aModelMorph;

/* options */

- (BOOL)autoLineLayout;
- autoLineLayout:(BOOL)aBoolean;
- automaticViewing:(BOOL)aBoolean;
- behaveLikeHolder;
- (BOOL)indicateCursor;
- indicateCursor:(BOOL)aBoolean;
- (BOOL)isPartsBin;
- isPartsBin:(BOOL)aBoolean;
- (BOOL)openToDragNDrop;
- openToDragNDrop:(BOOL)aBoolean;
- replaceTallSubmorphsByThumbnails;
- (BOOL)resizeToFit;
- resizeToFit:(BOOL)aBoolean;
- setPartsBinStatusTo:(BOOL)aBoolean;
- setThumbnailHeight;
- toggleAlwaysShowThumbnail;
- toggleAutoLineLayout;
- toggleAutomaticPhraseExpansion;
- toggleAutomaticViewing;
- toggleIndicateCursor;
- toggleIsPartsBin;
- toggleMouseOverHalos;
- toggleResizeToFit;
- updateSubmorphThumbnails;
- (BOOL)wantsMouseOverHalos;
- wantsMouseOverHalos:(BOOL)aBoolean;

/* painting */

- backgroundSketch;
- backgroundSketch:aSketchMorphOrNil;
- makeNewDrawingWithin;
- paintBackground;
- paintingBoundsAround:aPoint;
- reasonablePaintingExtent;

/* pen */

- clearTurtleTrails;
- createOrResizeTrailsForm;
- drawPenTrailFor:aMorph from:oldPoint to:newPoint;
- liftAllPens;
- lowerAllPens;
- trailMorph;

/* scripting */

- allTileScriptingElements;
- emptyAnonymousScriptorFrom:aPlaceHoldingMorph;
- emptyPermanentScriptorFrom:aPlaceHoldingMorph;
- expandPhrasesToScripts;
- scriptorForTextualScript:aSelector ofPlayer:aPlayer;

/* stack & card */

- becomeStack;
- doWrap;
- goToNextCard;
- goToPreviousCard;
- installAsCurrent:anInstance;
- (BOOL)isStackLike;
- morphsForInstanceData;
- newCard;
- scriptPerformer;

/* misc */

- abandonCostumeHistory;
- allScriptEditors;
- alwaysShowThumbnail;
- cachedOrNewThumbnail;
- color:aColor;
- (BOOL)demandsBoolean;
- fullBounds;
- heightForThumbnails;
- impartPrivatePresenter;
- innocuousName;
- invalidRect:aRect;
- (BOOL)isPlayfieldLike;
- makeDetachable;
- maxHeightToAvoidThumbnailing;
- maximumThumbnailWidth;
- mouseX;
- mouseY;
- navigateTo;
- padding:(int)anumber;
- prepareToBeSaved;
- presenter;
- presenter:aPresenter;
- replaceSubmorph:oldMorph by:newMorph;
- (BOOL)residesInPartsBin;
- roundUpStrays;
- slotNamesAndTypesForBank:aBank;
- smallThumbnailForPageSorter;
- startRunningAll;
- stepAll;
- stopRunningAll;
- thumbnailForPageSorter;
- unhideHiddenObjects;
- updateStatusForAllScriptEditors;
- (BOOL)wantsKeyboardFocusFor:aSubmorph;

/* flaps */

- accommodateFlap:aFlapTab;
- addGlobalFlaps;
- assureFlapTabsFitOnScreen;
- bringFlapTabsToFront;
- deleteAllFlapArtifacts;
- deleteGlobalFlapArtifacts;
- localFlapTabs;
- offsetForAccommodating:anExtent onEdge:edgeSymbol;
- removeAccommodationForFlap:aFlapTab;

@end
 
#define __PASTEUPMORPH_H__
#endif

