
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphicModel.m,v 1.3 1999/05/25 21:17:08 stes Exp $
 */

#include "MorphicModel.h"

@implementation MorphicModel

/* instance creation */

+ new { [self notImplemented]; }
+ (BOOL)includeInNewMorphMenu { [self notImplemented]; }
+ newBounds:bounds model:thang slotName:nameOfThisPart { [self notImplemented]; }

/* compilation */ 

+ chooseNewName { [self notImplemented]; }
+ newSubclass { [self notImplemented]; }
+ officialClass { [self notImplemented]; }

/* queries */

+ (BOOL)hasPrototype { [self notImplemented]; }

/* prototype access */

+ prototype { [self notImplemented]; }
+ prototype:aMorph { [self notImplemented]; }

/* housekeeping */

+ removeUninstantiatedModels { [self notImplemented]; }

/* initialization */

- delete { [self notImplemented]; }
- duplicate:newGuy from:oldGuy { [self notImplemented]; }
- initialize { [self notImplemented]; }
- model:anObject { [self notImplemented]; }
- model:thang slotName:nameOfThisPart { [self notImplemented]; }

/* access */

- allKnownNames { [self notImplemented]; }
- model { [self notImplemented]; }
- slotName { [self notImplemented]; }
- (BOOL)wantsSlot { [self notImplemented]; }

/* geometry */

- newBounds:newBounds { [self notImplemented]; }
- recomputeBounds { [self notImplemented]; }

/* printing */

- initString { [self notImplemented]; }

/* compilation */

- addPartsNameLike:classname withValue:aMorph { [self notImplemented]; }
- assureNameFor:anObject { [self notImplemented]; }
- choosePartName { [self notImplemented]; }
- installModelIn:aWorld { [self notImplemented]; }
- nameFor:aMorph { [self notImplemented]; }
- namePartSilently:anObject { [self notImplemented]; }
- propagate:value as:partStoreSelector { [self notImplemented]; }
- removeAll { [self notImplemented]; }

/* drag and drop */

- (BOOL)isOpen { [self notImplemented]; }
- (BOOL)openToDragNDrop { [self notImplemented]; }
- (BOOL)wantsDroppedMorph:aMorph event:evt { [self notImplemented]; }
- (BOOL)allowSubmorphExtraction { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }
- closeToEdits { [self notImplemented]; }
- openToEdits { [self notImplemented]; }

@end
 
