
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphicModel.h,v 1.3 1999/05/25 21:17:08 stes Exp $
 */

#ifndef __MORPHICMODEL_H__

#include <BorderedMorph.h>

@interface MorphicModel : BorderedMorph
{
	id model;
	id slotName;
	BOOL open;
}

/* instance creation */

+ new;
+ (BOOL)includeInNewMorphMenu;
+ newBounds:bounds model:thang slotName:nameOfThisPart;

/* compilation */ 

+ chooseNewName;
+ newSubclass;
+ officialClass;

/* queries */

+ (BOOL)hasPrototype;

/* prototype access */

+ prototype;
+ prototype:aMorph;

/* housekeeping */

+ removeUninstantiatedModels;

/* initialization */

- delete;
- duplicate:newGuy from:oldGuy;
- initialize;
- model:anObject;
- model:thang slotName:nameOfThisPart;

/* access */

- allKnownNames;
- model;
- slotName;
- (BOOL)wantsSlot;

/* geometry */

- newBounds:newBounds;
- recomputeBounds;

/* printing */

- initString;

/* compilation */

- addPartsNameLike:classname withValue:aMorph;
- assureNameFor:anObject;
- choosePartName;
- installModelIn:aWorld;
- nameFor:aMorph;
- namePartSilently:anObject;
- propagate:value as:partStoreSelector;
- removeAll;

/* drag and drop */

- (BOOL)isOpen;
- (BOOL)openToDragNDrop;
- (BOOL)wantsDroppedMorph:aMorph event:evt;
- (BOOL)allowSubmorphExtraction;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- closeToEdits;
- openToEdits;

@end
 
#define __MORPHICMODEL_H__
#endif

