
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphExtension.m,v 1.2 1999/05/24 16:14:05 stes Exp $
 */

#include "MorphExtension.h"

@implementation MorphExtension

/* initialization */

- initialize { [self notImplemented]; } 

/* copying */

- copyPropertiesFrom:donorMorph dict:dict { [self notImplemented]; }
- updateRefernecesUsing:aDictionary { [self notImplemented]; }

/* named access */

- actorState { [self notImplemented]; }
- actorState:newValue { [self notImplemented]; }
- balloonText { [self notImplemented]; }
- balloonText:newValue { [self notImplemented]; }
- balloonTextSelector { [self notImplemented]; }
- balloonTextSelector:newValue { [self notImplemented]; }
- eventHandler { [self notImplemented]; }
- eventHandler:newValue { [self notImplemented]; }
- externalName { [self notImplemented]; }
- externalName:newValue { [self notImplemented]; }
- (BOOL)isPartsDonor { [self notImplemented]; }
- isPartsDonor:(BOOL)newValue { [self notImplemented]; }
- locked { [self notImplemented]; }
- locked:(BOOL)newValue { [self notImplemented]; }
- player { [self notImplemented]; }
- player:newValue { [self notImplemented]; }
- (BOOL)sticky { [self notImplemented]; }
- sticky:(BOOL)newValue { [self notImplemented]; }
- (BOOL)visible { [self notImplemented]; }
- visible:(BOOL)visible { [self notImplemented]; }

/* other properties */

- (BOOL)hasProperty:propName { [self notImplemented]; }
- otherProperties { [self notImplemented]; }
- removeProperty { [self notImplemented]; }
- setProperty:propName toValue:aValue { [self notImplemented]; }
- valueOfProperty:propName { [self notImplemented]; }
- valueOfProperty:propName ifAbsent:aBlock { [self notImplemented]; }

/* printing */

- printOn:(IOD)iod { [self notImplemented]; }

@end
 
