
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MorphExtension.h,v 1.2 1999/05/24 16:13:01 stes Exp $
 */

#ifndef __MORPHEXTENSION_H__

#include <Object.h>

@interface MorphicExtension : Object
{
	BOOL locked;
	BOOL visible;
	BOOL sticky;
	BOOL isPartsDonor;
	id balloonText;
	id balloonTextSelector;
	id externalName;
	id actorState;
	id player;
	id eventHandler;
	id otherProperties;
}

/* initialization */

- initialize; 

/* copying */

- copyPropertiesFrom:donorMorph dict:dict;
- updateRefernecesUsing:aDictionary;

/* named access */

- actorState;
- actorState:newValue;
- balloonText;
- balloonText:newValue;
- balloonTextSelector;
- balloonTextSelector:newValue;
- eventHandler;
- eventHandler:newValue;
- externalName;
- externalName:newValue;
- (BOOL)isPartsDonor;
- isPartsDonor:(BOOL)newValue;
- locked;
- locked:(BOOL)newValue;
- player;
- player:newValue;
- (BOOL)sticky;
- sticky:(BOOL)newValue;
- (BOOL)visible;
- visible:(BOOL)visible;

/* other properties */

- (BOOL)hasProperty:propName;
- otherProperties;
- removeProperty;
- setProperty:propName toValue:aValue;
- valueOfProperty:propName;
- valueOfProperty:propName ifAbsent:aBlock;

/* printing */

- printOn:(IOD)iod;

@end
 
#define __MORPHEXTENSION_H__
#endif

