
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Morph.m,v 1.16 1999/06/16 20:20:35 stes Exp $
 */

#include "Morph.h"
#include <objpak.h>
#include <Color.h>
#include <WorldMorph.h>
#include <PasteUpMorph.h>
#include <MorphExtension.h>
#include <assert.h>
#include <FormCanvas.h>
#include <DisplayScreen.h>

@implementation Morph

/* Instance Creation */

+ authoringPrototype
{
  [self notImplemented];
}
 
+ authoringPrototypeIn:anEToyHolder
{
  [self notImplemented];
}

+ (BOOL)includeInNewMorphMenu
{
  [self notImplemented];
}

+ new
{
  return [[super new] initialize];
}

+ newBounds:bounds
{
  [self notImplemented];
}

+ newBounds:bounds color:color
{
  [self notImplemented];
}

+ newSticky
{
  [self notImplemented];
}

+ newWithExtent:extent
{
  [self notImplemented];
}

/* Class Initialization */

+ formalCostumeName
{
  [self notImplemented];
}

+ initialize
{
  return self;
}

/* Misc Class */

+ morphsUnknownToTheirOwners
{
  [self notImplemented];
}

+ repairMorphsUnknownToTheirOwners
{
  [self notImplemented];
}

/* Initialization */

- initialExtent
{
  [self notImplemented];
}

- initialize
{
  static id defbounds;
  if (!defbounds) defbounds = [Rectangle origin:0:0 corner:50:40];
  bounds = defbounds;
  submorphs = nil;
  color = [Color blue];
  return self;
}

- openInMVC
{
  [self notImplemented];
  return self;
}

- openInWorld
{
  if (World) {
    [self openInWorld:World];
  } else {
    World = [WorldMorph new];
  }
}

- openInWorld:aWorld
{
  [self notImplemented];
}

- standardPalette
{
  [self notImplemented];
}

/* Classification */

- (BOOL)isAlignmentMorph
{
  [self notImplemented];
}

- (BOOL)isFlashMorph
{
  [self notImplemented];
}

- (BOOL)isFlexMorph
{
  [self notImplemented];
}

- (BOOL)isHandMorph
{
  [self notImplemented];
}

- (BOOL)isLayoutMorph
{
  [self notImplemented];
}

- (BOOL)isMorph
{
  return YES;
}

- (BOOL)isPlayfieldLike
{
  [self notImplemented];
}

- (BOOL)isRenderer
{
  [self notImplemented];
}

- (BOOL)isWorldMorph
{
  [self notImplemented];
}

- (BOOL)isWorldOrHandMorph
{
  return [self isWorldMorph] || [self isHandMorph];
}

/* Accessing */

- actorState
{
  id state = [self actorStateOrNil];
#if 0
  if (state == nil) {
    state = [ActorState new] initializeFor:[self assuredPlayer]];
    [self actorState:state];
  }
#endif
  return state;
}

- actorState:anActorState
{
  [self notImplemented];
}

- actorStateOrNil
{
  return (extension)?[extension actorState]:nil;
}

- asMorph
{
  [self notImplemented];
}

- balloonHelpTextForHandle:aHandle
{
  [self notImplemented];
}

- balloonText
{
  [self notImplemented];
}

- balloonTextSelector:aSelector
{
  [self notImplemented];
}

- beSticky
{
  [self notImplemented];
}

- color
{
  [self notImplemented];
}

- color:aColor
{
  if (color == nil || [color notEqual:aColor]) {
    color = aColor;
    [self changed];
  }
  return self;
}

- colorForInsets
{
  [self notImplemented];
}

- (BOOL)colorSettable
{
  [self notImplemented];
}

- eventHandler
{
  [self notImplemented];
}

- eventHandler:anEventHandler
{
  [self notImplemented];
}

- forwardDirection
{
  [self notImplemented];
}

- (BOOL)hasTranslucentColor
{
  [self notImplemented];
}

- highlight
{
  [self notImplemented];
}

- highlightColor
{
  [self notImplemented];
}

- highlightColor:aColor
{
  [self notImplemented];
}

- (BOOL)isLocked
{
  [self notImplemented];
}

- (BOOL)isSticky
{
  [self notImplemented];
}

- lock
{
  [self notImplemented];
}

- lock:(BOOL)aBoolean
{
  [self notImplemented];
}

- player
{
  [self notImplemented];
}

- player:anObject
{
  [self notImplemented];
}

- regularColor
{
  [self notImplemented];
}

- regularColor:aColor
{
  [self notImplemented];
}

- toggleStickiness
{
  [self notImplemented];
}

- unHighlight
{
  [self notImplemented];
}

- unlock
{
  [self notImplemented];
}

- unlockContents
{
  [self notImplemented];
}

- url
{
  [self notImplemented];
}

- userString
{
  [self notImplemented];
}

/* Access Properties */

- (BOOL)hasProperty:propName
{
  [self notImplemented];
}

- removeProperty:propName
{
  [self notImplemented];
}

- setProperty:propName toValue:aValue
{
  [self notImplemented];
}

- valueOfProperty:propName
{
  [self notImplemented];
}

- valueOfProperty:propName ifAbsent:aBlock
{
  [self notImplemented];
}

/* Copying */

- copy
{
  [self notImplemented];
}

- copyRecordingIn:dict
{
  [self notImplemented];
}

- copyWithoutSubmorphs
{
  [self notImplemented];
}

- fullCopy
{
  [self notImplemented];
}

- updateReferencesUsing:aDictionary
{
  [self notImplemented];
}

- usableSiblingInstance
{
  [self notImplemented];
}

- veryDeepCopyWith:deepCopier
{
  [self notImplemented];
}

- veryDeepCopyWithoutPlayer
{
  [self notImplemented];
}

- veryDeepFixupWith:deepCopier
{
  [self notImplemented];
}

- veryDeepInner:deepCopier
{
  [self notImplemented];
}

/* Structure */

- activeHand
{
}

- eachStepInOwnerChainDo:aBlock
{
}

- (BOOL)isInWorld
{ [self notImplemented];
}

- nearestOwnerThat:aBlock
{ [self notImplemented];
}

- outermostMorphThat:aBlock
{ [self notImplemented];
}

- owner
{ 
  return owner; // may be nil
}

- ownerThatIsA:aClass
{ [self notImplemented];
}

- ownerThatIsAHandOrA:aClass
{ [self notImplemented];
}

- owningHandOrPasteUpMorph
{ [self notImplemented];
}

- pasteUpMorph
{ [self notImplemented];
}

- presenter
{ [self notImplemented];
}

- primaryHand
{ [self notImplemented];
}

- renderedMorph
{ [self notImplemented];
}

- root
{ [self notImplemented];
}

- topPasteUp
{ [self notImplemented];
}

- topRendererOrSelf
{ [self notImplemented];
}

- withAllContainers
{ [self notImplemented];
}

- world
{
  return (owner)?[owner world]:nil; 
}

/* Submorphs - Accessing */

- allMorphs
{ [self notImplemented];
}

- allMorphsDo:aBlock
{ [self notImplemented];
}

- allMorphsNotInPartsBins
{ [self notImplemented];
}

- allMorphsNotInPartsBinsDo:aBlock
{ [self notImplemented];
}

- allNonSubmorphMorphs
{ [self notImplemented];
}

- (BOOL)couldBeOwnedBy:aMorph
{ [self notImplemented];
}

- findA:aClass
{ [self notImplemented];
}

- findDeepSubmorphThat:block1 ifAbsent:block2
{ [self notImplemented];
}

- findInWorldA:aClass
{ [self notImplemented];
}

- findSubmorphThat:block1 ifAbsent:block2
{ [self notImplemented];
}

- firstSubmorph
{ [self notImplemented];
}

- hasSubmorphWithProperty:aSymbol
{ [self notImplemented];
}

- (BOOL)hasSubmorphs
{ [self notImplemented];
}

- lastSubmorph
{ [self notImplemented];
}

- morphsAt:aPoint
{ [self notImplemented];
}

- morphsAt:aPoint addTo:mList
{ [self notImplemented];
}

- (unsigned) submorphCount
{ [self notImplemented];
}

- submorphNamed:aName
{ [self notImplemented];
}

- submorphNamed:aName ifNone:aBlock
{ [self notImplemented];
}

- submorphOfClass:aClass
{ [self notImplemented];
}

- submorphWithProperty:aSymbol
{ [self notImplemented];
}

- submorphs
{ 
  // also see -privateSubmorphs
  return [submorphs copy];
}

- submorphsBehind:aMorph do:aBlock
{ [self notImplemented];
}

- submorphsDo:aBlock
{ 
  if (submorphs) [submorphs do:aBlock];
  return self;
}

- submorphsInFrontOf:aMorph do:aBlock
{ [self notImplemented];
}

- submorphsReverseDo:aBlock
{ [self notImplemented];
}

- submorphsSatisfying:aBlock
{ [self notImplemented];
}

- (BOOL)uncoveredAt:aPoint
{ [self notImplemented];
}

- unlockedMorphsAt:aPoint
{ [self notImplemented];
}

- unlockedMorphsAt:aPoint addTo:mList
{ [self notImplemented];
}

/* Submorphs - Add/Remove */

- abandon
{ [self notImplemented];
}

- addAllMorphs:aCollection
{ [self notImplemented];
}

- addMorph:aMorph
{ 
  return [self addMorphFront:aMorph];
}

- addMorphBack:aMorph
{ [self notImplemented];
}

- addMorphCentered:aMorph
{ [self notImplemented];
}

- addMorphFront:aMorph
{
  if ([aMorph owner]) [[aMorph owner] privateRemoveMorph:aMorph];
  [aMorph layoutChanged];
  [aMorph privateOwner:self];
  if (!submorphs) submorphs = [OrderedCollection new];
  [submorphs addFirst:aMorph];
  [aMorph changed];
  [self layoutChanged];
  return self;
}

- addMorphFront:aMorph fromWorldPosition:wp
{ [self notImplemented];
}

- addMorphNearBack:aMorph
{ [self notImplemented];
}

- copyWithoutSubmorph:sub
{ [self notImplemented];
}

- delete
{ [self notImplemented];
}

- deleteSubmorphsWithProperty:aSymbol
{ [self notImplemented];
}

- goBehind
{ [self notImplemented];
}

- privateDelete
{ [self notImplemented];
}

- removeAllMorphs
{ [self notImplemented];
}

- removeEmptyLayoutMorphs
{ [self notImplemented];
}

- replaceSubmorph:oldMorph by:newMorph
{ [self notImplemented];
}

/* Drawing */

- areasRemainingToFill:aRectangle
{ [self notImplemented];
}

//
// Provide a Canvas for drawing my submorphs.  This may be overridden
// to provide for clipping and other related behavior.
//

- canvasForSubmorphs:canvasForMe
{ 
  return canvasForMe;
}

- (BOOL)doesOwnRotation
{ [self notImplemented];
  return NO;
}

- drawErrorOn:aCanvas
{ [self notImplemented];
}

- drawOn:aCanvas
{ 
  [aCanvas fillRectangle:[self bounds] color:color];
  return self;
}

- flash
{ 
  id c,w;
  c  = [self color];
  [self color:[Color black]];
  if ( (w = [self world]) ) [w doOneSubCycle];
  [self color:c];
  return self;
}

- fullBounds
{
  if (fullBounds) {
    return fullBounds;
  } else {
    fullBounds = [self bounds];
    if (submorphs) [submorphs do:{ :m |
      if ([m visible]) {
	fullBounds = [fullBounds quickMerge:[m fullBounds]];
      }
    }];
    return fullBounds;
  }
}

- fullDrawOn:aCanvas
{ 
  if ([self visible]) {
    if ([aCanvas isVisible:[self fullBounds]]) {
      if ([aCanvas isVisible:bounds]) {
	[self drawOn:aCanvas];
      }
      if (submorphs) {
        id c = [self canvasForSubmorphs:aCanvas];
	int n = [submorphs size];
	while (n--) {
	  // display submorphs back to front
	  [[submorphs at:n] fullDrawOn:c];
	}
      }
      return self;
    } else {
      return self;
    }
  } else {
    return self;
  }
}

- fullDrawOn:aCanvas without:stopMorph andStopThere:stopThere
{ [self notImplemented];
}

- hide
{ 
  if (!owner) return self;
  if ([self visible]) [[self visible:NO] changed]; 
  return self;
}

- imageForm
{ 
  return [self imageFormForRectangle:[self fullBounds]];
}

- imageForm:depth forRectangle:rect
{
  id canvas;
  canvas = [FormCanvas extent:[rect extent] depth:depth];
  [self fullDrawOn:[canvas copyOffset:[[rect topLeft] negated]]]; 
  return [[canvas form] offset:[rect topLeft]];
}

- imageFormDepth:depth
{ 
  return [self imageForm:depth forRectangle:[self fullBounds]];
}

- imageFormForRectangle:rect
{
  return [self imageForm:[Display depth] forRectangle:rect];
}

- imageFormWithout:stopMorph andStopThere:stopThere
{ [self notImplemented];
}

- shadowForm
{ [self notImplemented];
}

- show
{ [self notImplemented];
}

- (BOOL)visible
{ 
  if (extension) { 
    return [extension visible];
  } else { 
    return YES;
  }
}

- visible:(BOOL)aBoolean
{ 
  if (extension == nil) { if (aBoolean) return self; }
  if (aBoolean == [self visible]) return self;
  [[self assuredExtension] visible:aBoolean];
  [self changed];
  return self;
}

/* Geometry */

- align:aPoint1 with:aPoint2
{ [self notImplemented];
}

- (int)bottom
{
  return [bounds bottom];
}

- bottom:(int)b { [self notImplemented]; }
- bottomLeft { [self notImplemented]; }
- bottomLeft:p { [self notImplemented]; }
- bottomRight { [self notImplemented]; }
- bottomRight:p { [self notImplemented]; }

- bounds
{
  return bounds;
}

- bounds:aRect { [self notImplemented]; }
- boundsInWorld { [self notImplemented]; }
- center { [self notImplemented]; }

- extent
{
  return [Point x:[bounds width] y:[bounds height]];
}

- extent:e
{
  if ([e x] != [bounds width] || [e y] != [bounds height]) {
    [self changed];
    [bounds extent:e];
    [self layoutChanged];
    [self changed];
  }
  return self;
}

- fullBoundsInWorld { [self notImplemented]; }

- (int)height
{
  return [bounds height];
}

- height:(int)h { [self notImplemented]; }
- innerBounds { [self notImplemented]; }

- (int)left
{
  return [bounds left];
}

- left:(int)l { [self notImplemented]; }
- (int)minHeight { [self notImplemented]; }
- (int)minWidth { [self notImplemented]; }
- nextOwnerPage { [self notImplemented]; }
- pointFromWorld:aPoint { [self notImplemented]; }
- pointInWorld { [self notImplemented]; }

- position
{
  return [bounds origin];
}

- position:p
{
  int x,y;
  id q = [bounds origin];
  
  x = [p x] - [q x];
  y = [p y] - [q y];

  if (x == 0 && y == 0) {
    return self;
  } else {
    id delta = [Point x:x y:y];
    [self changed];
    [self privateFullMoveBy:delta];
    [self changed];
    return self;
  }
}

- positionAtBottomLeft { [self notImplemented]; }
- positionAtBottomRight { [self notImplemented]; }
- positionInWorld { [self notImplemented]; }
- positionSubmorphs { [self notImplemented]; }
- previousOwnerPage { [self notImplemented]; }

- (int)right
{
  return [bounds right];
}

- right:(int)right { [self notImplemented]; }
- screenLocation { [self notImplemented]; }
- screenRectangle { [self notImplemented]; }
- setConstrainedPositionFrom:aPoint { [self notImplemented]; }
- shiftSubmorphsBy:delta { [self notImplemented]; }
- shiftSubmorphsOtherThan:dontShift by:delta { [self notImplemented]; }

- (int)top
{
  return [bounds top];
}

- top:(int)top { [self notImplemented]; }
- topLeft { [self notImplemented]; }
- topLeft:p { [self notImplemented]; }
- topRight { [self notImplemented]; }
- topRight:t { [self notImplemented]; }
- (int)width { [self notImplemented]; }
- width:(int)w { [self notImplemented]; }
- worldBounds { [self notImplemented]; }

/* Geometry E-Toy */

- referencePosition
{
  return [bounds center];
}

/* Rotate, Scale and Flex */

- addFlexShell
{ [self notImplemented];
}

- keepsTransform
{ [self notImplemented];
}

- maxScaleFactor
{ [self notImplemented];
}

- newScaleFactor:newScaleFactor previousScaleFactor:oldScaleFactor
{ [self notImplemented];
}

- newTransformationMorph
{ [self notImplemented];
}

- rotationDegrees
{ [self notImplemented];
}

/* Geometry Testing */

- (BOOL)containsPoint:aPoint
{ [self notImplemented];
}

- (BOOL)fullContainsPoint:aPoint
{ [self notImplemented];
}

/* Thumbnail */

- newThumbnailOfHeight:aHeight
{ [self notImplemented];
}

- representiveNoTallerThan:maxHeight norWiderThan:maxWidth thumbnailHeight:thumbnailHeight
{ [self notImplemented];
}

/* Dropping, Grabbing */

- aboutToBeGrabbedBy:aHand
{ [self notImplemented];
}

- acceptDroppingMorph:aMorph event:evt
{ [self notImplemented];
}

- (BOOL)allowSubmorphExtraction
{ [self notImplemented];
}

- closeDragAndDrop
{ [self notImplemented];
}

- justDroppedInto:aMorph event:anEvent
{ [self notImplemented];
}

- morphToDropFrom:m
{ [self notImplemented];
  return m;
}

- morphToGrabFrom:m
{ [self notImplemented];
  return m;
}

- openDragAndDrop
{ [self notImplemented];
}

- (BOOL)repelsMorph:aMorph event:ev
{ [self notImplemented];
}

- rootForGrabOf:aMorph
{ [self notImplemented];
}

- slideBackToFormerSituation:evt
{ [self notImplemented];
}

- slideToTrash:evt
{ [self notImplemented];
}

- substituteForMorph:aMorph beingDroppedOn:aPage
{ [self notImplemented];
}

- vanishAfterSlidingTo:aPosition event:evt
{ [self notImplemented];
}

- (BOOL)wantsDroppedMorph:aMorph event:evt
{ [self notImplemented];
}

- (BOOL)wantsToBeOpenedInWorld
{ [self notImplemented];
  return NO;
}

/* Event Handling */

- click:evt
{ [self notImplemented];
}

- cursorPoint
{ [self notImplemented];
}

- doubleClick:evt
{ [self notImplemented];
}

- drag:evt
{ [self notImplemented];
}

- (BOOL)handlesMouseDown:evt
{ [self notImplemented];
}

- (BOOL)handlesMouseOver:evt
{ [self notImplemented];
}

- (BOOL)handlesMouseOverDragging:evt
{ [self notImplemented];
}

- (BOOL)hasFocus
{ [self notImplemented];
  return NO;
}

- keyStroke:anEvent
{ [self notImplemented];
  return self;
}

- keyboardFocusChange:(BOOL)aBoolean
{ [self notImplemented];
}

- mouseDown:evt
{ [self notImplemented];
}

- mouseEnter:evt
{ [self notImplemented];
}

- mouseEnterDragging:evt
{ [self notImplemented];
}

- mouseLeave:evt
{ [self notImplemented];
}

- mouseLeaveDragging:evt
{ [self notImplemented];
}

- mouseMove:evt
{ [self notImplemented];
}

- mouseUp:evt
{ [self notImplemented];
}

- on:eventName send:selector to:recipient
{ [self notImplemented];
}

- on:eventName send:selector to:recipient withValue:value
{ [self notImplemented];
}

- preemptsMouseDown:evt
{ [self notImplemented];
}

- removeLink:actionCode
{ [self notImplemented];
}

- restoreSuspendedEventHandler
{ [self notImplemented];
}

- suspendEventHandler
{ [self notImplemented];
}

- transformForm:ueberMorph
{ [self notImplemented];
}

- transformFromWorld
{ [self notImplemented];
}

- (BOOL)trumpsMouseDown:evt
{ [self notImplemented];
  return NO;
}

- (BOOL)wantsKeyboardFocusFor:aSubmorph
{ [self notImplemented];
  return NO;
}

- (BOOL)wouldAcceptKeyboardFocus
{ [self notImplemented];
  return NO;
}

/* Pen */

- choosePenColor:evt
{ [self notImplemented];
}

- choosePenSize
{ [self notImplemented];
}

- getPenColor
{ [self notImplemented];
}

- (BOOL)getPenDown
{ 
  if ([self player] == nil) return NO;
  return [[self actorState] getPenDown];
}

- getPenSize
{ [self notImplemented];
}

- liftPen
{ [self notImplemented];
}

- lowerPen
{ [self notImplemented];
}

- penColor:aColor
{ [self notImplemented];
}

- penUpWhile:changeBlock
{ [self notImplemented];
}

- trailMorph
{ 
  return (owner)?[owner trailMorph]:nil;
}

/* Naming */

- allSubmorphNames
{ [self notImplemented];
}

- choosePartName
{ [self notImplemented];
}

- choosePartNameSilently
{ [self notImplemented];
}

- externalName
{ 
  return ([self knownName])?[self knownName]:[self innocuousName];
}

- formalCostumeName
{ [self notImplemented];
}

- innocuousName
{ [self notImplemented];
}

- knownName
{ 
  return (extension)?[extension externalName]:nil;
}

- name:aName
{ [self notImplemented];
}

- nameInModel
{ [self notImplemented];
}

- renameTo:aName
{ [self notImplemented];
}

- setNamePropertyTo:aName
{
  if (extension == nil) [self assureExtension];
  [extension externalName:aName];
  return self;
}

- setNameTo:aName
{ 
  assert([aName isKindOf:String]);
  [self setNamePropertyTo:aName];
  return self;
}

- specialNameInModel
{ [self notImplemented];
}

- updateWorldAfterRenaming
{ [self notImplemented];
}

/* Stepping and Presenter */

- arrangeToStartStepping
{ [self notImplemented];
}

- arrangeToStartSteppingIn:aWorld
{ [self notImplemented];
}

- (BOOL)isStepping
{ [self notImplemented];
}

- playfield
{ [self notImplemented];
}

- start
{ [self notImplemented];
}

- startStepping
{ [self notImplemented];
}

- startSteppingIn:aWorld
{ [self notImplemented];
}

- step
{ [self notImplemented];
}

- stepTime
{ [self notImplemented];
}

- stop
{ [self notImplemented];
}

- stopStepping
{ 
  id w = [self world];
  if (!w) { [w stopStepping:self]; [self changed]; }
  return self;
}

- (BOOL)wantsSteps
{ [self notImplemented];
}

/* Menus */

- addAddHandMenuItemsForHalo:aMenu hand:aHandMorph
{ [self notImplemented];
}

- addCustomHaloMenuItems:aMenu hand:aHandMorph
{ [self notImplemented];
}

- addCustomMenuItems:aCustomMenu hand:aHandMorph
{ [self notImplemented];
}

- addDropShadow
{ [self notImplemented];
}

- addPaintingItemsTo:aMenu hand:aHandMorph
{ [self notImplemented];
}

- adhereToEdge
{ [self notImplemented];
}

- adhereToEdge:edgeSymbol
{ [self notImplemented];
}

- chooseNewGraphic
{ [self notImplemented];
}

- chooseNewGraphicCoexisting:(BOOL)aBoolean
{ [self notImplemented];
}

- inspectInMorphic
{ [self notImplemented];
}

- setToAdhereToEdge:anEdge
{ [self notImplemented];
}

- snapToEdgeIfAppropriate
{
  return self;
}

/* Halos and balloon help */

- addFontHandlesTo:aHalo box:box
{ [self notImplemented];
}

- addHalo
{ [self notImplemented];
}

- addOptionalHandlesTo:aHalo box:box
{ [self notImplemented];
}

- deleteBalloon
{ [self notImplemented];
}

- editBalloonHelpContext:aString
{ [self notImplemented];
}

- editBalloonHelpText
{ [self notImplemented];
}

- halo
{ [self notImplemented];
}

- (BOOL)hasHalo
{ [self notImplemented];
}

- mouseDownOnHelpHandle:anEvent
{ [self notImplemented];
}

- noHelpString
{ [self notImplemented];
}

- removeHalo
{ [self notImplemented];
}

- setBalloonText:stringOrText
{ [self notImplemented];
}

- setBalloonText:stringOrText maxLineLength:aLength
{ [self notImplemented];
}

- showBalloon:msgString
{ [self notImplemented];
}

- (BOOL)wantsBalloon
{ [self notImplemented];
}

- (BOOL)wantsHalo
{ [self notImplemented];
}

- (BOOL)wantsHaloFor:aSubMorph
{ [self notImplemented];
}

/* Change Reporting */

- changed
{
  [self invalidRect:[self fullBounds]];
  return self;
}

- colorChangedForSubmorph:aSubmorph
{ [self notImplemented];
}

- invalidRect:damageRect
{
  if (owner) [owner invalidRect:damageRect];
  return self;
}

- layoutChanged
{ 
  fullBounds = nil;
  if (owner) [owner layoutChanged];
  if (submorphs) [submorphs do: { :m | [m ownerChanged]; }];
  return self;
}

- ownerChanged
{
  [self snapToEdgeIfAppropriate];
  return self;
}

- userSelectedColor:aColor
{ [self notImplemented];
}

/* Player */

- assureExternalName
{ 
  if (![self knownName]) [self setNameTo:[self externalName]];
  return self;
}

- assuredPlayer
{ 
  id aPlayer = [self player];
  if (aPlayer) {
    return aPlayer;
  } else {
#if 0
    [self assureExternalName];
    [self player:aPlayer = [self newPlayerInstance]];
    [aPlayer costume:self];
    if ([self presenter]) [[self presenter] flushPlayerListCache];
#endif
    return aPlayer;
  }
}

- newPlayerInstance
{ [self notImplemented];
}

- okayToDuplicate
{ [self notImplemented];
}

- showPlayerMenu
{ [self notImplemented];
}

/* Player Commands */

- beep
{ [self notImplemented];
}

- beep:soundname
{ [self notImplemented];
}

- jumpTo:aPoint
{ [self notImplemented];
}

- makeFenceSound
{ [self notImplemented];
}

- set:aPointOrNumber
{ [self notImplemented];
}

- wearCostume:anotherMorph
{ [self notImplemented];
}

/* Player Viewer */

- openViewerForArgument
{ [self notImplemented];
}

- slotNamesAndTypesForBank:aNumber
{ [self notImplemented];
}

- updateLiteralLabel
{ [self notImplemented];
}

/* Button */

- addLabel:aString
{ [self notImplemented];
}

- addLabel:aString outset:aPoint
{ [self notImplemented];
}

/* Parts Bin */

- (BOOL)inPartsBin
{ [self notImplemented];
}

- (BOOL)isPartBin
{ [self notImplemented];
}

- (BOOL)isPartsDonor
{ [self notImplemented];
}

- isPartsDonor:(BOOL)aBoolean
{ [self notImplemented];
}

- markAsPartsDonor
{ [self notImplemented];
}

- (BOOL)residesInPartsBin
{ [self notImplemented];
}

/* Printing */

- colorString:aColor
{ [self notImplemented];
}

- constructorString
{ [self notImplemented];
}

- defaultLabelForInspector
{ [self notImplemented];
}

- fullPrintOn:(IOD)aStream
{ [self notImplemented];
}

- initString
{ [self notImplemented];
}

- printConstructorOn:(IOD)aStream indent:level
{ [self notImplemented];
}

- printConstructorOn:(IOD)aStream indent:level nodeDict:nodeDict
{ [self notImplemented];
}

- printOn:(IOD)anIOD
{ [self notImplemented];
}

- printStructureOn:(IOD)aStream indent:tabcount
{ [self notImplemented];
}

- structureString
{ [self notImplemented];
}

/* Property Extension */

- assureExtension
{ [self notImplemented];
}

- assuredExtension
{ [self notImplemented];
}

- copyPropertiesFrom:donorMorph dict:dict
{ [self notImplemented];
}

- extension
{ [self notImplemented];
}

- otherProperties
{ [self notImplemented];
}

/* Caching */

- fullLoadCacheState
{ [self notImplemented];
}

- fullReleaseCachedState
{ [self notImplemented];
}

- loadCachedState
{ [self notImplemented];
}

- releaseCachedState
{ [self notImplemented];
}

/* Debugging */

- addDebuggingItemsTo:aMenu hand:aHandMorph
{ [self notImplemented];
}

- allStringsAfter:aSubmorph
{ [self notImplemented];
}

- debuggingMenuFor:aHandMorph
{ [self notImplemented];
}

- defineTempCommand
{ [self notImplemented];
}

- inspectOwnerChain
{ [self notImplemented];
}

- installModelIn:ignored
{ [self notImplemented];
}

- ownerChain
{ [self notImplemented];
}

- resumeAfterDrawError
{ [self notImplemented];
}

- resumeAfterStepError
{ [self notImplemented];
}

- slotSpecifications
{ [self notImplemented];
}

- tempCommand
{ [self notImplemented];
}

/* Private Messages */

- privateAddMorph:aMorph atIndex:index
{ [self notImplemented];
}

- privateBounds:boundsrect
{ [self notImplemented];
}

- privateColor:aColor
{ [self notImplemented];
}

- privateFullBounds:boundsrect
{ [self notImplemented];
}

- privateFullMoveBy:delta
{ 
  int i,n;

  [self privateMoveBy:delta];

  if (submorphs) for(i=0,n=[submorphs size];i<n;i++) {
    [[submorphs at:i] privateFullMoveBy:delta];
  }

  return self;
}

//
// This is the private method that does the work for -position:
//

- privateMoveBy:delta
{
  if (extension != nil && [extension player] != nil) {
    if ([self getPenDown]) {
      id trailmorph = [self trailMorph];
      if (trailmorph) {
	id start = [self referencePosition];
	id end = [start translateBy:delta];
	[trailmorph drawPenTrailFor:self from:start to:end];
      }
    }
  }

  if (fullBounds == bounds) {
    bounds = [bounds translateBy:delta];
    fullBounds = bounds;
  } else {
    fullBounds = nil;
    bounds = [bounds translateBy:delta];
  } 
  
  return self;
}

- privateOwner:aMorph
{ 
  owner = aMorph;
  return self;
}

- privateRemoveMorph:aMorph
{
  [aMorph changed];
  [submorphs remove:aMorph];
  [self layoutChanged];
  return self;
}

- privateSubmorphs
{ 
  return submorphs;
}

- privateSubmorphs:aCollection
{ [self notImplemented];
}

@end
 
