
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Morph.h,v 1.9 1999/05/30 17:31:30 stes Exp $
 */

#ifndef __MORPH_H__

#include <Object.h>

@interface Morph : Object
{
	id bounds;
	id owner;
	id submorphs;
	id fullBounds;
	id color;
	id extension;
}

/* Instance Creation */

+ authoringPrototype;
+ authoringPrototypeIn:anEToyHolder;
+ (BOOL)includeInNewMorphMenu;
+ new;
+ newBounds:bounds;
+ newBounds:bounds color:color;
+ newSticky;
+ newWithExtent:extent;

/* Class Initialization */

+ formalCostumeName;
+ initialize;

/* Class Misc */

+ morphsUnknownToTheirOwners;
+ repairMorphsUnknownToTheirOwners;

/* Initialization */

- initialExtent;
- initialize;
- openInMVC;
- openInWorld;
- openInWorld:aWorld;
- standardPalette;

/* Classification */

- (BOOL)isAlignmentMorph;
- (BOOL)isFlashMorph;
- (BOOL)isFlexMorph;
- (BOOL)isHandMorph;
- (BOOL)isLayoutMorph;
- (BOOL)isMorph;
- (BOOL)isPlayfieldLike;
- (BOOL)isRenderer;
- (BOOL)isWorldMorph;
- (BOOL)isWorldOrHandMorph;

/* Accessing */

- actorState;
- actorState:anActorState;
- actorStateOrNil;
- asMorph;
- balloonHelpTextForHandle:aHandle;
- balloonText;
- balloonTextSelector:aSelector;
- beSticky;
- color;
- color:aColor;
- colorForInsets;
- (BOOL)colorSettable;
- eventHandler;
- eventHandler:anEventHandler;
- forwardDirection;
- (BOOL)hasTranslucentColor;
- highlight;
- highlightColor;
- highlightColor:aColor;
- (BOOL)isLocked;
- (BOOL)isSticky;
- lock;
- lock:(BOOL)aBoolean;
- player;
- player:anObject;
- regularColor;
- regularColor:aColor;
- toggleStickiness;
- unHighlight;
- unlock;
- unlockContents;
- url;
- userString;

/* Access Properties */

- (BOOL)hasProperty:propName;
- removeProperty:propName;
- setProperty:propName toValue:aValue;
- valueOfProperty:propName;
- valueOfProperty:propName ifAbsent:aBlock;

/* Copying */

- copy;
- copyRecordingIn:dict;
- copyWithoutSubmorphs;
- fullCopy;
- updateReferencesUsing:aDictionary;
- usableSiblingInstance;
- veryDeepCopyWith:deepCopier;
- veryDeepCopyWithoutPlayer;
- veryDeepFixupWith:deepCopier;
- veryDeepInner:deepCopier;

/* Structure */

- activeHand;
- eachStepInOwnerChainDo:aBlock;
- (BOOL)isInWorld;
- nearestOwnerThat:aBlock;
- outermostMorphThat:aBlock;
- owner;
- ownerThatIsA:aClass;
- ownerThatIsAHandOrA:aClass;
- owningHandOrPasteUpMorph;
- pasteUpMorph;
- presenter;
- primaryHand;
- renderedMorph;
- root;
- topPasteUp;
- topRendererOrSelf;
- withAllContainers;
- world;

/* Submorphs - Accessing */

- allMorphs;
- allMorphsDo:aBlock;
- allMorphsNotInPartsBins;
- allMorphsNotInPartsBinsDo:aBlock;
- allNonSubmorphMorphs;
- (BOOL)couldBeOwnedBy:aMorph;
- findA:aClass;
- findDeepSubmorphThat:block1 ifAbsent:block2;
- findInWorldA:aClass;
- findSubmorphThat:block1 ifAbsent:block2;
- firstSubmorph;
- hasSubmorphWithProperty:aSymbol;
- (BOOL)hasSubmorphs;
- lastSubmorph;
- morphsAt:aPoint;
- morphsAt:aPoint addTo:mList;
- (unsigned) submorphCount;
- submorphNamed:aName;
- submorphNamed:aName ifNone:aBlock;
- submorphOfClass:aClass;
- submorphWithProperty:aSymbol;
- submorphs;
- submorphsBehind:aMorph do:aBlock;
- submorphsDo:aBlock;
- submorphsInFrontOf:aMorph do:aBlock;
- submorphsReverseDo:aBlock;
- submorphsSatisfying:aBlock;
- (BOOL)uncoveredAt:aPoint;
- unlockedMorphsAt:aPoint;
- unlockedMorphsAt:aPoint addTo:mList;

/* Submorphs - Add/Remove */

- abandon;
- addAllMorphs:aCollection;
- addMorph:aMorph;
- addMorphBack:aMorph;
- addMorphCentered:aMorph;
- addMorphFront:aMorph;
- addMorphFront:aMorph fromWorldPosition:wp;
- addMorphNearBack:aMorph;
- copyWithoutSubmorph:sub;
- delete;
- deleteSubmorphsWithProperty:aSymbol;
- goBehind;
- privateDelete;
- removeAllMorphs;
- removeEmptyLayoutMorphs;
- replaceSubmorph:oldMorph by:newMorph;

/* Drawing */

- areasRemainingToFill:aRectangle;
- canvasForSubmorphs:canvasForMe;
- (BOOL)doesOwnRotation;
- drawErrorOn:aCanvas;
- drawOn:aCanvas;
- flash;
- fullBounds;
- fullDrawOn:aCanvas;
- fullDrawOn:aCanvas without:stopMorph andStopThere:stopThere;
- hide;
- imageForm;
- imageForm:depth forRectangle:rect;
- imageFormDepth:depth;
- imageFormForRectangle:rect;
- imageFormWithout:stopMorph andStopThere:stopThere;
- shadowForm;
- show;
- (BOOL)visible;
- visible:(BOOL)aBoolean;

/* Geometry */

- align:aPoint1 with:aPoint2;
- (int)bottom;
- bottom:(int)b;
- bottomLeft;
- bottomLeft:p;
- bottomRight;
- bottomRight:p;
- bounds;
- bounds:aRect;
- boundsInWorld;
- center;
- extent;
- extent:aPoint;
- fullBoundsInWorld;
- (int)height;
- height:(int)h;
- innerBounds;
- (int)left;
- left:(int)l;
- (int)minHeight;
- (int)minWidth;
- nextOwnerPage;
- pointFromWorld:aPoint;
- pointInWorld;
- position;
- position:p;
- positionAtBottomLeft;
- positionAtBottomRight;
- positionInWorld;
- positionSubmorphs;
- previousOwnerPage;
- (int)right;
- right:(int)right;
- screenLocation;
- screenRectangle;
- setConstrainedPositionFrom:aPoint;
- shiftSubmorphsBy:delta;
- shiftSubmorphsOtherThan:dontShift by:delta;
- (int)top;
- top:(int)top;
- topLeft;
- topLeft:p;
- topRight;
- topRight:t;
- (int)width;
- width:(int)w;
- worldBounds;

/* Rotate, Scale and Flex */

- addFlexShell;
- keepsTransform;
- maxScaleFactor;
- newScaleFactor:newScaleFactor previousScaleFactor:oldScaleFactor;
- newTransformationMorph;
- rotationDegrees;

/* Geometry Testing */

- (BOOL)containsPoint:aPoint;
- (BOOL)fullContainsPoint:aPoint;

/* Thumbnail */;

- newThumbnailOfHeight:aHeight;
- representiveNoTallerThan:maxHeight norWiderThan:maxWidth thumbnailHeight:thumbnailHeight;

/* Dropping, Grabbing */

- aboutToBeGrabbedBy:aHand;
- acceptDroppingMorph:aMorph event:evt;
- (BOOL)allowSubmorphExtraction;
- closeDragAndDrop;
- justDroppedInto:aMorph event:anEvent;
- morphToDropFrom:m;
- morphToGrabFrom:m;
- openDragAndDrop;
- (BOOL)repelsMorph:aMorph event:ev;
- rootForGrabOf:aMorph;
- slideBackToFormerSituation:evt;
- slideToTrash:evt;
- substituteForMorph:aMorph beingDroppedOn:aPage;
- vanishAfterSlidingTo:aPosition event:evt;
- (BOOL)wantsDroppedMorph:aMorph event:evt;
- (BOOL)wantsToBeOpenedInWorld;

/* Event Handling */

- click:evt;
- cursorPoint;
- doubleClick:evt;
- drag:evt;
- (BOOL)handlesMouseDown:evt;
- (BOOL)handlesMouseOver:evt;
- (BOOL)handlesMouseOverDragging:evt;
- (BOOL)hasFocus;
- keyStroke:anEvent;
- keyboardFocusChange:(BOOL)aBoolean;
- mouseDown:evt;
- mouseEnter:evt;
- mouseEnterDragging:evt;
- mouseLeave:evt;
- mouseLeaveDragging:evt;
- mouseMove:evt;
- mouseUp:evt;
- on:eventName send:selector to:recipient;
- on:eventName send:selector to:recipient withValue:value;
- preemptsMouseDown:evt;
- removeLink:actionCode;
- restoreSuspendedEventHandler;
- suspendEventHandler;
- transformForm:ueberMorph;
- transformFromWorld;
- (BOOL)trumpsMouseDown:evt;
- (BOOL)wantsKeyboardFocusFor:aSubmorph;
- (BOOL)wouldAcceptKeyboardFocus;

/* Pen */

- choosePenColor:evt;
- choosePenSize;
- getPenColor;
- (BOOL)getPenDown;
- getPenSize;
- liftPen;
- lowerPen;
- penColor:aColor;
- penUpWhile:changeBlock;
- trailMorph;

/* Naming */

- allSubmorphNames;
- choosePartName;
- choosePartNameSilently;
- externalName;
- formalCostumeName;
- innocuousName;
- knownName;
- name:aName;
- nameInModel;
- renameTo:aName;
- setNamePropertyTo:aName;
- setNameTo:aName;
- specialNameInModel;
- updateWorldAfterRenaming;

/* Stepping and Presenter */

- arrangeToStartStepping;
- arrangeToStartSteppingIn:aWorld;
- (BOOL)isStepping;
- playfield;
- start;
- startStepping;
- startSteppingIn:aWorld;
- step;
- stepTime;
- stop;
- stopStepping;
- (BOOL)wantsSteps;

/* Menus */

- addAddHandMenuItemsForHalo:aMenu hand:aHandMorph;
- addCustomHaloMenuItems:aMenu hand:aHandMorph;
- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- addDropShadow;
- addPaintingItemsTo:aMenu hand:aHandMorph;
- adhereToEdge;
- adhereToEdge:edgeSymbol;
- chooseNewGraphic;
- chooseNewGraphicCoexisting:(BOOL)aBoolean;
- inspectInMorphic;
- setToAdhereToEdge:anEdge;
- snapToEdgeIfAppropriate;

/* Halos and balloon help */

- addFontHandlesTo:aHalo box:box;
- addHalo;
- addOptionalHandlesTo:aHalo box:box;
- deleteBalloon;
- editBalloonHelpContext:aString;
- editBalloonHelpText;
- halo;
- (BOOL)hasHalo;
- mouseDownOnHelpHandle:anEvent;
- noHelpString;
- removeHalo;
- setBalloonText:stringOrText;
- setBalloonText:stringOrText maxLineLength:aLength;
- showBalloon:msgString;
- (BOOL)wantsBalloon;
- (BOOL)wantsHalo;
- (BOOL)wantsHaloFor:aSubMorph;

/* Change Reporting */

- changed;
- colorChangedForSubmorph:aSubmorph;
- invalidRect:damageRect;
- layoutChanged;
- ownerChanged;
- userSelectedColor:aColor;

/* Player */

- assureExternalName;
- assuredPlayer;
- newPlayerInstance;
- okayToDuplicate;
- showPlayerMenu;

/* Player Commands */

- beep;
- beep:soundname;
- jumpTo:aPoint;
- makeFenceSound;
- set:aPointOrNumber;
- wearCostume:anotherMorph;

/* Player Viewer */

- openViewerForArgument;
- slotNamesAndTypesForBank:aNumber;
- updateLiteralLabel;

/* Button */

- addLabel:aString;
- addLabel:aString outset:aPoint;

/* Parts Bin */;

- (BOOL)inPartsBin;
- (BOOL)isPartBin;
- (BOOL)isPartsDonor;
- isPartsDonor:(BOOL)aBoolean;
- markAsPartsDonor;
- (BOOL)residesInPartsBin;

/* Printing */

- colorString:aColor;
- constructorString;
- defaultLabelForInspector;
- fullPrintOn:(IOD)aStream;
- initString;
- printConstructorOn:(IOD)aStream indent:level;
- printConstructorOn:(IOD)aStream indent:level nodeDict:nodeDict;
- printOn:(IOD)anIOD;
- printStructureOn:(IOD)aStream indent:tabcount;
- structureString;

/* Property Extension */

- assureExtension;
- assuredExtension;
- copyPropertiesFrom:donorMorph dict:dict;
- extension;
- otherProperties;

/* Caching */

- fullLoadCacheState;
- fullReleaseCachedState;
- loadCachedState;
- releaseCachedState;

/* Debugging */

- addDebuggingItemsTo:aMenu hand:aHandMorph;
- allStringsAfter:aSubmorph;
- debuggingMenuFor:aHandMorph;
- defineTempCommand;
- inspectOwnerChain;
- installModelIn:ignored;
- ownerChain;
- resumeAfterDrawError;
- resumeAfterStepError;
- slotSpecifications;
- tempCommand;

/* Private Messages */

- privateAddMorph:aMorph atIndex:index;
- privateBounds:boundsrect;
- privateColor:aColor;
- privateFullBounds:boundsrect;
- privateFullMoveBy:delta;
- privateMoveBy:delta;
- privateOwner:aMorph;
- privateRemoveMorph:aMorph;
- privateSubmorphs;
- privateSubmorphs:aCollection;

@end
 
#define __MORPH_H__
#endif

