
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: HandMorph.m,v 1.2 1999/05/24 15:54:39 stes Exp $
 */

#include "HandMorph.h"

@implementation HandMorph

/* initialization */

- initForEvents { [self notImplemented]; }
- initialize { [self notImplemented]; }

/* classification */

- (BOOL)isHandMorph { [self notImplemented]; }

/* accessing */

- argument { [self notImplemented]; }
- lastEvent { [self notImplemented]; }
- setArgument:arg { [self notImplemented]; }
- targetOffset { [self notImplemented]; }
- userInitials { [self notImplemented]; }

/* cursor */

- cursorBounds { [self notImplemented]; }
- showTemporaryCursor:cursorOrNil { [self notImplemented]; }
- showTemporaryCursor:cursorOrNil hotSpotOffset:hotSpotOffset { [self notImplemented]; }

/* geometry */

- changed { [self notImplemented]; }
- fullBounds { [self notImplemented]; }
- invalidRect:aRect { [self notImplemented]; }
- position { [self notImplemented]; }
- position:aPoint { [self notImplemented]; }
- userInitials:aString { [self notImplemented]; }

/* drawing */

- colorForInsets { [self notImplemented]; }
- drawOn:aCanvas { [self notImplemented]; }
- fullDrawOn:aCanvas { [self notImplemented]; }
- (BOOL)hasChanged { [self notImplemented]; }
- (BOOL)needsToBeDrawn { [self notImplemented]; }
- nonCachingFullDrawOn:aCanvas { [self notImplemented]; }
- restoreSavedPatchOn:aCanvas { [self notImplemented]; }
- savePatchFrom:aCanvas { [self notImplemented]; }
- shadowForm { [self notImplemented]; }
- shadowOffset { [self notImplemented]; }
- trailMorph { [self notImplemented]; }
- updateCacheCanvasDepth:depth { [self notImplemented]; }

/* event handling */

- addMouseOverMorph:aMorph { [self notImplemented]; }
- gridPointRaw { [self notImplemented]; }
- handleDragOver:evt { [self notImplemented]; }
- handleEvent:evt { [self notImplemented]; }
- handleMouseDown:evt { [self notImplemented]; }
- handleMouseMove:evt { [self notImplemented]; }
- handleMouseOver:evt { [self notImplemented]; }
- handleMouseUp:evt { [self notImplemented]; }
- keyboardFocus { [self notImplemented]; }
- mouseOverList:evt { [self notImplemented]; }
- mouveOverList:evt rank:rank { [self notImplemented]; }
- newKeyboardFocus:aMorphOrNil { [self notImplemented]; }
- newMouseFocus:aMorphOrNil { [self notImplemented]; }
- noteSignificantEvent:evt { [self notImplemented]; }
- pauseEventRecorderIn:aWorld { [self notImplemented]; }
- processEvents { [self notImplemented]; }
- recipientForMouseDown:evt { [self notImplemented]; }
- startReportingEventsTo:subscriber { [self notImplemented]; }
- stopReportingEventsTo:subscriber { [self notImplemented]; }
- transformEvent:evt { [self notImplemented]; }
- updateMouseDownTransform { [self notImplemented]; }

/* double click support */

- checkForDoubleClick:evt { [self notImplemented]; }
- resetClickState { [self notImplemented]; }
- waitForClicksOrDrag:aMorph event:evt { [self notImplemented]; }

/* grabbing/dropping */

- attachMorph:m { [self notImplemented]; }
- dropMorphsEvent:evt { [self notImplemented]; }
- dropTargetFor:aMorph event:evt { [self notImplemented]; }
- grabMorph:m { [self notImplemented]; }
- grabMorphFromMenu:m { [self notImplemented]; }

/* world menu */

- buildWorldMenu { [self notImplemented]; }
- changesDo { [self notImplemented]; }
- changesMenu { [self notImplemented]; }
- debugDo { [self notImplemented]; }
- debugMenu { [self notImplemented]; }
- helpDo { [self notImplemented]; }
- helpMenu { [self notImplemented]; }
- newMorph { [self notImplemented]; }
- openMenu { [self notImplemented]; }
- openWindow { [self notImplemented]; }
- remoteDo { [self notImplemented]; }
- remoteMenu { [self notImplemented]; }
- scriptingDo { [self notImplemented]; }
- scriptingMenu { [self notImplemented]; }
- windowsDo { [self notImplemented]; }
- windowsMenu { [self notImplemented]; }
- worldMenuHelp { [self notImplemented]; }

/* world menu commands */

- absorbUpdatesFromServer { [self notImplemented]; }
- argumentOrNil { [self notImplemented]; }
- beThisWorldsModel { [self notImplemented]; }
- browseChangedMessages { [self notImplemented]; }
- browseMorphClass { [self notImplemented]; }
- browsePlayerClass { [self notImplemented]; }
- buildDebugHandleMenuFor:argMorph { [self notImplemented]; }
- buildMorphHandleMenuFor:argMorph { [self notImplemented]; }
- buildMorphMenuFor:argMorph { [self notImplemented]; }
- callTempCommand { [self notImplemented]; }
- changeBackgroundColor { [self notImplemented]; }
- changeColor { [self notImplemented]; }
- changeColorTarget:aMorph selector:aSymbol { [self notImplemented]; }
- changeVariableType { [self notImplemented]; }
- chooseColor { [self notImplemented]; }
- chooseNewCostumeForArgument { [self notImplemented]; }
- chooseTargetSubmorphOf:root caption:caption { [self notImplemented]; }
- classOfPasteBuffer { [self notImplemented]; }
- cleanUpWorld { [self notImplemented]; }
- closeUnchangedWindows { [self notImplemented]; }
- collapseAll { [self notImplemented]; }
- copyToPasteBuffer { [self notImplemented]; }
- defineTempCommand { [self notImplemented]; }
- deleteNonWindows { [self notImplemented]; }
- detachableScriptingSpace { [self notImplemented]; }
- dismissMorph { [self notImplemented]; }
- drawingClass { [self notImplemented]; }
- duplicateMorph { [self notImplemented]; }
- expandAll { [self notImplemented]; }
- findDirtyBrowsers { [self notImplemented]; }
- findDirtyWindows { [self notImplemented]; }
- findWindow { [self notImplemented]; }
- goBehind { [self notImplemented]; }
- grabDrawingFromScreen { [self notImplemented]; }
- grapMorph { [self notImplemented]; }
- inspectArgument { [self notImplemented]; }
- inspectArgumentInMorphic { [self notImplemented]; }
- inspectArgumentsPlayerInMorphic { [self notImplemented]; }
- inspectMorph { [self notImplemented]; }
- inspectMorphInMorphic { [self notImplemented]; }
- inspectPlayer { [self notImplemented]; }
- inspectWorldModel { [self notImplemented]; }
- invokeMenu:aMenu event:evt { [self notImplemented]; }
- invokeMetaMenu:evt { [self notImplemented]; }
- jumpToProject { [self notImplemented]; }
- lockMorph { [self notImplemented]; }
- makeAliasForArgument { [self notImplemented]; }
- maybeDuplicateMorph { [self notImplemented]; }
- nameMorph { [self notImplemented]; }
- newDrawingFromMenu { [self notImplemented]; }
- newMorphOfClass:morphClass event:evt { [self notImplemented]; }
- objectToPaste { [self notImplemented]; }
- offerFlapsMenu { [self notImplemented]; }
- openBrowser { [self notImplemented]; }
- openChangeSorter:oneOrTwo { [self notImplemented]; }
- openChangesLog { [self notImplemented]; }
- openConstructionProject { [self notImplemented]; }
- openEmail { [self notImplemented]; }
- openFileList { [self notImplemented]; }
- openIRC { [self notImplemented]; }
- openMorphicProject { [self notImplemented]; }
- openRecentChanges { [self notImplemented]; }
- openScrapsBook { [self notImplemented]; }
- openViewerForArgument { [self notImplemented]; }
- openWebBrowser { [self notImplemented]; }
- openWorkspace { [self notImplemented]; }
- operateOnSubmorph:aMorph event:evt { [self notImplemented]; }
- pasteMorph { [self notImplemented]; }
- placeArgumentIn { [self notImplemented]; }
- potentialEmbeddingTargets { [self notImplemented]; }
- projectThumbnail { [self notImplemented]; }
- quitSession { [self notImplemented]; }
- readMorphFromAFile { [self notImplemented]; }
- resizeMorph { [self notImplemented]; }
- saveAndQuit { [self notImplemented]; }
- saveAs { [self notImplemented]; }
- saveAsPrototype { [self notImplemented]; }
- saveOnFile { [self notImplemented]; }
- savePicturesOfWorld { [self notImplemented]; }
- saveSession { [self notImplemented]; }
- saveWorldInFile { [self notImplemented]; }
- selectEmbedTargetMorph:caption { [self notImplemented]; }
- selectSubmorphToOperateOn:rootMorph sending:aSymbol event:evt { [self notImplemented]; }
- setDisplayDepth { [self notImplemented]; }
- setGridding { [self notImplemented]; }
- showActions { [self notImplemented]; }
- startMessageTally { [self notImplemented]; }
- subclassMorph { [self notImplemented]; }
- submorphNameFor:aMorph { [self notImplemented]; }
- unlockContents { [self notImplemented]; }
- unlockOneSubpart { [self notImplemented]; }
- writeInitMethodForModel { [self notImplemented]; }

/* special gestures */

- specialDrag:evt { [self notImplemented]; }
- specialGesture:evt { [self notImplemented]; }

/* halos */

- addHalo { [self notImplemented]; }
- chooseHaloSubmorphOf:root caption:caption { [self notImplemented]; }
- invokeMetaMenuFor:aMorph { [self notImplemented]; }
- popUpHalo:evt { [self notImplemented]; }
- popUpHaloFromClick:evt { [self notImplemented]; }

/* remote morphic */

- cleanupDeadConnections { [self notImplemented]; }
- connectRemoteUser { [self notImplemented]; }
- disconnectAllRemoteUsers { [self notImplemented]; }
- disconnectRemoteUser { [self notImplemented]; }
- readyToTransmit { [self notImplemented]; }
- reportLocalAddress { [self notImplemented]; }
- startTransmittingEvents { [self notImplemented]; }
- stopTransmittingEvents { [self notImplemented]; }
- transmitEvent:aMorphicEvent { [self notImplemented]; }

/* from EtoyHand */

- clearPaletteArea { [self notImplemented]; }
- endDisplaySuppression { [self notImplemented]; }
- formerOwner { [self notImplemented]; }
- formerPosition { [self notImplemented]; }
- makeNewDrawingInBounds:rect pasteUpMorph:aPasteUpMorph { [self notImplemented]; }
- makeNewPlayerInstance { [self notImplemented]; }
- rejectDropMorph:aMorph event:evt { [self notImplemented]; }
- roundUpStrayObjects { [self notImplemented]; }
- showHiders { [self notImplemented]; }
- startDisplaySuppression { [self notImplemented]; }
- suppressDisplay { [self notImplemented]; }
- unlockWorldContents { [self notImplemented]; }

/* copying */

- veryDeepCopyWith:deepCopier { [self notImplemented]; }

@end 

