
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: HandMorph.h,v 1.2 1999/05/24 15:54:39 stes Exp $
 */

#ifndef __HANDMORPH_H__

#include <Morph.h>

@interface HandMorph : Morph
{
}

/* initialization */

- initForEvents;
- initialize;

/* classification */

- (BOOL)isHandMorph;

/* accessing */

- argument;
- lastEvent;
- setArgument:arg;
- targetOffset;
- userInitials;

/* cursor */

- cursorBounds;
- showTemporaryCursor:cursorOrNil;
- showTemporaryCursor:cursorOrNil hotSpotOffset:hotSpotOffset;

/* geometry */

- changed;
- fullBounds;
- invalidRect:aRect;
- position;
- position:aPoint;
- userInitials:aString;

/* drawing */

- colorForInsets;
- drawOn:aCanvas;
- fullDrawOn:aCanvas;
- (BOOL)hasChanged;
- (BOOL)needsToBeDrawn;
- nonCachingFullDrawOn:aCanvas;
- restoreSavedPatchOn:aCanvas;
- savePatchFrom:aCanvas;
- shadowForm;
- shadowOffset;
- trailMorph;
- updateCacheCanvasDepth:depth;

/* event handling */

- addMouseOverMorph:aMorph;
- gridPointRaw;
- handleDragOver:evt;
- handleEvent:evt;
- handleMouseDown:evt;
- handleMouseMove:evt;
- handleMouseOver:evt;
- handleMouseUp:evt;
- keyboardFocus;
- mouseOverList:evt;
- mouveOverList:evt rank:rank;
- newKeyboardFocus:aMorphOrNil;
- newMouseFocus:aMorphOrNil;
- noteSignificantEvent:evt;
- pauseEventRecorderIn:aWorld;
- processEvents;
- recipientForMouseDown:evt;
- startReportingEventsTo:subscriber;
- stopReportingEventsTo:subscriber;
- transformEvent:evt;
- updateMouseDownTransform;

/* double click support */

- checkForDoubleClick:evt;
- resetClickState;
- waitForClicksOrDrag:aMorph event:evt;

/* grabbing/dropping */

- attachMorph:m;
- dropMorphsEvent:evt;
- dropTargetFor:aMorph event:evt;
- grabMorph:m;
- grabMorphFromMenu:m;

/* world menu */

- buildWorldMenu;
- changesDo;
- changesMenu;
- debugDo;
- debugMenu;
- helpDo;
- helpMenu;
- newMorph;
- openMenu;
- openWindow;
- remoteDo;
- remoteMenu;
- scriptingDo;
- scriptingMenu;
- windowsDo;
- windowsMenu;
- worldMenuHelp;

/* world menu commands */

- absorbUpdatesFromServer;
- argumentOrNil;
- beThisWorldsModel;
- browseChangedMessages;
- browseMorphClass;
- browsePlayerClass;
- buildDebugHandleMenuFor:argMorph;
- buildMorphHandleMenuFor:argMorph;
- buildMorphMenuFor:argMorph;
- callTempCommand;
- changeBackgroundColor;
- changeColor;
- changeColorTarget:aMorph selector:aSymbol;
- changeVariableType;
- chooseColor;
- chooseNewCostumeForArgument;
- chooseTargetSubmorphOf:root caption:caption;
- classOfPasteBuffer;
- cleanUpWorld;
- closeUnchangedWindows;
- collapseAll;
- copyToPasteBuffer;
- defineTempCommand;
- deleteNonWindows;
- detachableScriptingSpace;
- dismissMorph;
- drawingClass;
- duplicateMorph;
- expandAll;
- findDirtyBrowsers;
- findDirtyWindows;
- findWindow;
- goBehind;
- grabDrawingFromScreen;
- grapMorph;
- inspectArgument;
- inspectArgumentInMorphic;
- inspectArgumentsPlayerInMorphic;
- inspectMorph;
- inspectMorphInMorphic;
- inspectPlayer;
- inspectWorldModel;
- invokeMenu:aMenu event:evt;
- invokeMetaMenu:evt;
- jumpToProject;
- lockMorph;
- makeAliasForArgument;
- maybeDuplicateMorph;
- nameMorph;
- newDrawingFromMenu;
- newMorphOfClass:morphClass event:evt;
- objectToPaste;
- offerFlapsMenu;
- openBrowser;
- openChangeSorter:oneOrTwo;
- openChangesLog;
- openConstructionProject;
- openEmail;
- openFileList;
- openIRC;
- openMorphicProject;
- openRecentChanges;
- openScrapsBook;
- openViewerForArgument;
- openWebBrowser;
- openWorkspace;
- operateOnSubmorph:aMorph event:evt;
- pasteMorph;
- placeArgumentIn;
- potentialEmbeddingTargets;
- projectThumbnail;
- quitSession;
- readMorphFromAFile;
- resizeMorph;
- saveAndQuit;
- saveAs;
- saveAsPrototype;
- saveOnFile;
- savePicturesOfWorld;
- saveSession;
- saveWorldInFile;
- selectEmbedTargetMorph:caption;
- selectSubmorphToOperateOn:rootMorph sending:aSymbol event:evt;
- setDisplayDepth;
- setGridding;
- showActions;
- startMessageTally;
- subclassMorph;
- submorphNameFor:aMorph;
- unlockContents;
- unlockOneSubpart;
- writeInitMethodForModel;

/* special gestures */

- specialDrag:evt;
- specialGesture:evt;

/* halos */

- addHalo;
- chooseHaloSubmorphOf:root caption:caption;
- invokeMetaMenuFor:aMorph;
- popUpHalo:evt;
- popUpHaloFromClick:evt;

/* remote morphic */

- cleanupDeadConnections;
- connectRemoteUser;
- disconnectAllRemoteUsers;
- disconnectRemoteUser;
- readyToTransmit;
- reportLocalAddress;
- startTransmittingEvents;
- stopTransmittingEvents;
- transmitEvent:aMorphicEvent;

/* from EtoyHand */

- clearPaletteArea;
- endDisplaySuppression;
- formerOwner;
- formerPosition;
- makeNewDrawingInBounds:rect pasteUpMorph:aPasteUpMorph;
- makeNewPlayerInstance;
- rejectDropMorph:aMorph event:evt;
- roundUpStrayObjects;
- showHiders;
- startDisplaySuppression;
- suppressDisplay;
- unlockWorldContents;

/* copying */

- veryDeepCopyWith:deepCopier;

@end 

#define __HANDMORPH_H__
#endif

