
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: BorderedMorph.m,v 1.5 1999/05/30 17:31:30 stes Exp $
 */

#include "BorderedMorph.h"
#include <Color.h>

@implementation BorderedMorph

/* initialization */

- initialize
{
  [super initialize];
  borderColor = [Color black];
  borderWidth = 2;
  return self;
}

/* accessing */

- borderColor
{
  return borderColor;
}

- borderColor:aColor
{
  borderColor = aColor;
  return self;
}

- borderInset
{
  [self notImplemented];
}

- borderRaised
{
  [self notImplemented];
}

- (int)borderWidth
{
  return borderWidth;
}

- borderWidth:(int)w
{
  borderWidth = w;return self;
}

- (BOOL)doesBevels
{
  [self notImplemented];
}

- (BOOL)hasTranslucentColor
{
  [self notImplemented];
}

- wearCostume:anotherMorph
{
  [self notImplemented];
}

/* drawing */

- areasRemainingToFill:aRectangle
{
  [self notImplemented];
}

- drawOn:aCanvas
{
  [self notImplemented];
}

/* geometry */

- innerBounds
{
  [self notImplemented];
}

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph
{
  [self notImplemented];
}

- changeBorderColor:aColor
{
  [self notImplemented];
}

- changeBorderWidth:(int)w
{
  [self notImplemented];
}

- slotNamesAndTypesForBank:aNumber
{
  [self notImplemented];
}

/* printing */

- fullPrintOn:(IOD)iod
{
  [self notImplemented];
}

/* private */

- setBorderWidth:(int)w borderColor:bc
{
  borderWidth = w;
  borderColor = bc;
  return self;
}

- setColor:c borderWidth:(int)w borderColor:bc
{
  [self color:c];
  [self borderWidth:w];
  [self borderColor:bc];
  return self;
}

@end
 
