
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: BorderedMorph.h,v 1.3 1999/05/24 14:08:40 stes Exp $
 */

#ifndef __BORDEREDMORPH_H__

#include <Morph.h>

@interface BorderedMorph : Morph
{
	id borderColor;
	int borderWidth;
}

/* initialization */

- initialize;

/* accessing */

- borderColor;
- borderColor:aColor;
- borderInset;
- borderRaised;
- (int)borderWidth;
- borderWidth:(int)w;
- (BOOL)doesBevels;
- (BOOL)hasTranslucentColor;
- wearCostume:anotherMorph;

/* drawing */

- areasRemainingToFill:aRectangle;
- drawOn:aCanvas;

/* geometry */

- innerBounds;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- changeBorderColor:aColor;
- changeBorderWidth:(int)w;
- slotNamesAndTypesForBank:aNumber;

/* printing */

- fullPrintOn:(IOD)iod;

/* private */

- setBorderWidth:(int)w borderColor:bc;
- setColor:c borderWidth:(int)w borderColor:bc;

@end
 
#define __BORDEREDMORPH_H__
#endif

