
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Form.m,v 1.2 1999/06/06 20:25:59 stes Exp $
 */

#include "Form.h"

@implementation Form 

/* instance creation */

+ extent:pt { [self notImplemented]; }
+ extent:pt depth:(int)bps { [self notImplemented]; }
+ extent:pt depth:(int)bps bits:aBitmap { [self notImplemented]; }

/* access */

- form { [self notImplemented]; }
- bits { [self notImplemented]; }
- bits:aBitmap { [self notImplemented]; }
- extent { [self notImplemented]; }
- extent:pt { [self notImplemented]; }
- (int)width { [self notImplemented]; }
- (int)height { [self notImplemented]; }
- (unsigned)depth { [self notImplemented]; }
- depth:(int)bps { [self notImplemented]; }
- offset { [self notImplemented]; }
- offset:aPoint { [self notImplemented]; }

/* copying */

- copy:aRect { [self notImplemented]; }
- copy:dstRect from:srcPt in:srcForm rule:(int)rule { [self notImplemented]; }
- copy:srcRect from:srcForm to:dstPt rule:(int)rule { [self notImplemented]; }
- deepCopy { [self notImplemented]; }
- veryDeepCopyWith:deepCopier { [self notImplemented]; }
- asFormOfDepth:(int)bps { [self notImplemented]; }

/* displaying */

- copyBits:srcRect from:srcForm at:dstOrigin clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }
- displayOn:aDisplayMedium at:aDisplayPoint clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }
- drawLine:srcForm from:beginPoint to:endPoint clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }

/* display box access */

- boundingBox { [self notImplemented]; }
- computeBoundingBox { [self notImplemented]; }

/* filling */

- anyShapeFill { [self notImplemented]; }
- colorAt:aPoint { [self notImplemented]; }
- colorAt:aPoint put:aColor { [self notImplemented]; }
- fill:aRect rule:(int)rule fillColor:aForm { [self notImplemented]; }

/* bordering */

- (int)borderWidth { [self notImplemented]; }
- borderWidth:(int)w { [self notImplemented]; }
- border:rect width:(int)w rule:(int)r fillColor:fillColor { [self notImplemented]; }

/* scaling, rotating */

- magnifyBy:(float)scale { [self notImplemented]; }
- shrink:aRect by:(float)scale { [self notImplemented]; }
- magnify:aRect by:(float)scale { [self notImplemented]; }
- rotateBy:(int)degrees { [self notImplemented]; }

/* private */

- setExtent:e depth:(int)bps { [self notImplemented]; }
- setExtent:e depth:(int)bps bits:aBitmap { [self notImplemented]; }

@end

