
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Form.h,v 1.2 1999/06/06 20:25:59 stes Exp $
 */

#ifndef __FORM_H__

#include <DisplayMedium.h>

/* Combination Rule Constants */

#define R_AND 1
#define R_BLEND	24
#define R_BLEND_ALPHA 30
#define R_ERASE	4
#define R_OVER 3
#define R_PAINT 25
#define R_PAINT_ALPHA 31
#define R_REVERSE 6
#define R_UNDER 7

@interface Form : DisplayMedium
{
  id bits;
  id extent;
  int depth;
  id offset;
}

/* instance creation */

+ extent:pt;
+ extent:pt depth:(int)bps;
+ extent:pt depth:(int)bps bits:aBitmap;

/* access */

- form;
- bits;
- bits:aBitmap;
- extent;
- extent:pt;
- (int)width;
- (int)height;
- (unsigned)depth;
- depth:(int)bps;
- offset;
- offset:aPoint;

/* copying */

- copy:aRect;
- copy:dstRect from:srcPt in:srcForm rule:(int)rule;
- copy:srcRect from:srcForm to:dstPt rule:(int)rule;
- deepCopy;
- veryDeepCopyWith:deepCopier;
- asFormOfDepth:(int)bps;

/* displaying */

- copyBits:srcRect from:srcForm at:dstOrigin clippingBox:clipRect rule:(int)rule fillColor:aForm;
- displayOn:aDisplayMedium at:aDisplayPoint clippingBox:clipRect rule:(int)rule fillColor:aForm;
- drawLine:srcForm from:beginPoint to:endPoint clippingBox:clipRect rule:(int)rule fillColor:aForm;

/* display box access */

- boundingBox;
- computeBoundingBox;

/* filling */

- anyShapeFill;
- colorAt:aPoint;
- colorAt:aPoint put:aColor;
- fill:aRect rule:(int)rule fillColor:aForm;

/* bordering */

- (int)borderWidth;
- borderWidth:(int)w;
- border:rect width:(int)w rule:(int)r fillColor:fillColor;

/* scaling, rotating */

- magnifyBy:(float)scale;
- shrink:aRect by:(float)scale;
- magnify:aRect by:(float)scale;
- rotateBy:(int)degrees;

/* private */

- setExtent:e depth:(int)bps;
- setExtent:e depth:(int)bps bits:aBitmap;

@end
 
#define __FORM_H__
#endif

